/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.textstructure.structurefinder;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.core.XmlUtils;
import org.elasticsearch.xpack.core.textstructure.structurefinder.FieldStats;
import org.elasticsearch.xpack.core.textstructure.structurefinder.TextStructure;
import org.elasticsearch.xpack.textstructure.structurefinder.TextStructureFinder;
import org.elasticsearch.xpack.textstructure.structurefinder.TextStructureOverrides;
import org.elasticsearch.xpack.textstructure.structurefinder.TextStructureUtils;
import org.elasticsearch.xpack.textstructure.structurefinder.TimeoutChecker;
import org.elasticsearch.xpack.textstructure.structurefinder.TimestampFormatFinder;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XmlTextStructureFinder
implements TextStructureFinder {
    private final List<String> sampleMessages;
    private final TextStructure structure;

    static XmlTextStructureFinder makeXmlTextStructureFinder(List<String> explanation, String sample, String charsetName, Boolean hasByteOrderMarker, TextStructureOverrides overrides, TimeoutChecker timeoutChecker) throws IOException, ParserConfigurationException, SAXException {
        Tuple<SortedMap<String, Object>, SortedMap<String, FieldStats>> mappingsAndFieldStats;
        String messagePrefix;
        try (Scanner scanner = new Scanner(sample);){
            messagePrefix = scanner.next();
        }
        DocumentBuilderFactory docBuilderFactory = XmlTextStructureFinder.makeDocBuilderFactory();
        ArrayList<String> sampleMessages = new ArrayList<String>();
        ArrayList sampleRecords = new ArrayList();
        String[] sampleDocEnds = sample.split(Pattern.quote(messagePrefix));
        StringBuilder preamble = new StringBuilder(sampleDocEnds[0]);
        int linesConsumed = XmlTextStructureFinder.numNewlinesIn(sampleDocEnds[0]);
        for (int i = 1; i < sampleDocEnds.length; ++i) {
            String sampleDoc = messagePrefix + sampleDocEnds[i];
            if (i < 3) {
                preamble.append(sampleDoc);
            }
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            try (ByteArrayInputStream is = new ByteArrayInputStream(sampleDoc.getBytes(StandardCharsets.UTF_8));){
                sampleRecords.add(XmlTextStructureFinder.docToMap(docBuilder.parse(is)));
                sampleMessages.add(sampleDoc);
                linesConsumed += XmlTextStructureFinder.numNewlinesIn(sampleDoc);
                timeoutChecker.check("XML parsing");
                continue;
            }
            catch (SAXException e) {
                if (!sampleRecords.isEmpty() && i >= sampleDocEnds.length - 1) continue;
                throw e;
            }
        }
        if (!sample.endsWith("\n")) {
            ++linesConsumed;
        }
        sampleDocEnds = null;
        assert (messagePrefix.charAt(0) == '<');
        String topLevelTag = messagePrefix.substring(1);
        TextStructure.Builder structureBuilder = new TextStructure.Builder(TextStructure.Format.XML).setCharset(charsetName).setHasByteOrderMarker(hasByteOrderMarker).setSampleStart(preamble.toString()).setNumLinesAnalyzed(linesConsumed).setNumMessagesAnalyzed(sampleRecords.size()).setMultilineStartPattern("^\\s*<" + topLevelTag);
        Tuple<String, TimestampFormatFinder> timeField = TextStructureUtils.guessTimestampField(explanation, sampleRecords, overrides, timeoutChecker);
        if (timeField != null) {
            boolean needClientTimeZone = ((TimestampFormatFinder)timeField.v2()).hasTimezoneDependentParsing();
            structureBuilder.setTimestampField((String)timeField.v1()).setJodaTimestampFormats(((TimestampFormatFinder)timeField.v2()).getJodaTimestampFormats()).setJavaTimestampFormats(((TimestampFormatFinder)timeField.v2()).getJavaTimestampFormats()).setNeedClientTimezone(needClientTimeZone).setEcsCompatibility(overrides.getEcsCompatibility()).setIngestPipeline(TextStructureUtils.makeIngestPipelineDefinition(null, Collections.emptyMap(), null, Collections.emptyMap(), topLevelTag + "." + (String)timeField.v1(), ((TimestampFormatFinder)timeField.v2()).getJavaTimestampFormats(), needClientTimeZone, ((TimestampFormatFinder)timeField.v2()).needNanosecondPrecision(), overrides.getEcsCompatibility()));
        }
        if ((mappingsAndFieldStats = TextStructureUtils.guessMappingsAndCalculateFieldStats(explanation, sampleRecords, timeoutChecker, overrides.getTimestampFormat())).v2() != null) {
            structureBuilder.setFieldStats((Map)mappingsAndFieldStats.v2());
        }
        Map innerFieldMappings = (Map)mappingsAndFieldStats.v1();
        LinkedHashMap<String, Object> secondLevelProperties = new LinkedHashMap<String, Object>();
        secondLevelProperties.put("type", "object");
        secondLevelProperties.put("properties", innerFieldMappings);
        TreeMap<String, Map<String, Object>> outerFieldMappings = new TreeMap<String, Map<String, Object>>();
        outerFieldMappings.put(topLevelTag, secondLevelProperties);
        if (timeField != null) {
            outerFieldMappings.put("@timestamp", ((TimestampFormatFinder)timeField.v2()).getEsDateMappingTypeWithoutFormat());
        }
        TextStructure structure = structureBuilder.setMappings(Collections.singletonMap("properties", outerFieldMappings)).setExplanation(explanation).build();
        return new XmlTextStructureFinder(sampleMessages, structure);
    }

    private static DocumentBuilderFactory makeDocBuilderFactory() throws ParserConfigurationException {
        DocumentBuilderFactory docBuilderFactory = XmlUtils.getHardenedBuilderFactory();
        docBuilderFactory.setNamespaceAware(false);
        docBuilderFactory.setValidating(false);
        return docBuilderFactory;
    }

    private XmlTextStructureFinder(List<String> sampleMessages, TextStructure structure) {
        this.sampleMessages = Collections.unmodifiableList(sampleMessages);
        this.structure = structure;
    }

    @Override
    public List<String> getSampleMessages() {
        return this.sampleMessages;
    }

    @Override
    public TextStructure getStructure() {
        return this.structure;
    }

    private static int numNewlinesIn(String str) {
        return (int)str.chars().filter(c -> c == 10).count();
    }

    private static Map<String, Object> docToMap(Document doc) {
        LinkedHashMap<String, Object> docAsMap = new LinkedHashMap<String, Object>();
        doc.getDocumentElement().normalize();
        XmlTextStructureFinder.addNodeToMap(doc.getDocumentElement(), docAsMap);
        return docAsMap;
    }

    private static void addNodeToMap(Node node, Map<String, Object> nodeAsMap) {
        NamedNodeMap attributes = node.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Node attribute = attributes.item(i);
            nodeAsMap.put(attribute.getNodeName(), attribute.getNodeValue());
        }
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 1) continue;
            if (child.getChildNodes().getLength() == 1) {
                Node grandChild = child.getChildNodes().item(0);
                String value = grandChild.getNodeValue().trim();
                if (value.isEmpty()) continue;
                nodeAsMap.put(child.getNodeName(), value);
                continue;
            }
            LinkedHashMap<String, Object> childNodeAsMap = new LinkedHashMap<String, Object>();
            XmlTextStructureFinder.addNodeToMap(child, childNodeAsMap);
            if (childNodeAsMap.isEmpty()) continue;
            nodeAsMap.put(child.getNodeName(), childNodeAsMap);
        }
    }
}

