/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.security;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;

public class LoginUtil {
    private static final String SUN_KRB5_LOGIN_MODULE = "com.sun.security.auth.module.Krb5LoginModule";
    private static final String KERBEROS_CONFIG_NAME = "es-hadoop-user-kerberos";

    public static LoginContext login(String userPrincipal, String password) throws LoginException {
        Set<KerberosPrincipal> principals = Collections.singleton(new KerberosPrincipal(userPrincipal));
        Subject subject = new Subject(false, principals, Collections.emptySet(), Collections.emptySet());
        KerberosPasswordConfiguration loginConf = new KerberosPasswordConfiguration(userPrincipal);
        KerberosPasswordCallbackHandler callback = new KerberosPasswordCallbackHandler(userPrincipal, password);
        LoginContext loginContext = new LoginContext(KERBEROS_CONFIG_NAME, subject, callback, loginConf);
        loginContext.login();
        return loginContext;
    }

    public static LoginContext keytabLogin(String userPrincipal, String keytab) throws LoginException {
        Set<KerberosPrincipal> principals = Collections.singleton(new KerberosPrincipal(userPrincipal));
        Subject subject = new Subject(false, principals, Collections.emptySet(), Collections.emptySet());
        KerberosKeytabConfiguration loginConf = new KerberosKeytabConfiguration(userPrincipal, keytab);
        LoginContext loginContext = new LoginContext(KERBEROS_CONFIG_NAME, subject, null, loginConf);
        loginContext.login();
        return loginContext;
    }

    private static class KerberosPasswordConfiguration
    extends Configuration {
        private final String principalName;

        public KerberosPasswordConfiguration(String principalName) {
            this.principalName = principalName;
        }

        @Override
        public AppConfigurationEntry[] getAppConfigurationEntry(String name) {
            HashMap<String, String> options = new HashMap<String, String>();
            options.put("principal", this.principalName);
            options.put("storeKey", "true");
            options.put("isInitiator", "true");
            options.put("refreshKrb5Config", "true");
            return new AppConfigurationEntry[]{new AppConfigurationEntry(LoginUtil.SUN_KRB5_LOGIN_MODULE, AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, options)};
        }
    }

    private static class KerberosPasswordCallbackHandler
    implements CallbackHandler {
        private final String principalName;
        private final String password;

        public KerberosPasswordCallbackHandler(String principalName, String password) {
            this.principalName = principalName;
            this.password = password;
        }

        @Override
        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            for (Callback callback : callbacks) {
                PasswordCallback pc;
                if (!(callback instanceof PasswordCallback) || !(pc = (PasswordCallback)callback).getPrompt().contains(this.principalName)) continue;
                pc.setPassword(this.password.toCharArray());
                break;
            }
        }
    }

    private static class KerberosKeytabConfiguration
    extends Configuration {
        private final String principalName;
        private final String keytabFile;

        public KerberosKeytabConfiguration(String principalName, String keytabFile) {
            this.principalName = principalName;
            this.keytabFile = keytabFile;
        }

        @Override
        public AppConfigurationEntry[] getAppConfigurationEntry(String name) {
            HashMap<String, String> options = new HashMap<String, String>();
            options.put("doNotPrompt", "true");
            options.put("principal", this.principalName);
            options.put("storeKey", "true");
            options.put("isInitiator", "true");
            options.put("refreshKrb5Config", "true");
            options.put("useKeyTab", "true");
            options.put("keyTab", this.keytabFile);
            return new AppConfigurationEntry[]{new AppConfigurationEntry(LoginUtil.SUN_KRB5_LOGIN_MODULE, AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, options)};
        }
    }
}

