/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.settings;

import java.util.function.Predicate;
import org.logstash.settings.IntegerSetting;

public final class PortSetting
extends IntegerSetting {
    public static final Predicate<Integer> VALID_PORT_RANGE = new Predicate<Integer>(){

        @Override
        public boolean test(Integer integer) {
            return PortSetting.isValid(integer);
        }
    };

    public PortSetting(String name, Integer defaultValue) {
        super(name, defaultValue);
    }

    public PortSetting(String name, Integer defaultValue, boolean strict) {
        this(name, defaultValue, strict, VALID_PORT_RANGE);
    }

    protected PortSetting(String name, Integer defaultValue, boolean strict, Predicate<Integer> validator) {
        super(name, defaultValue, strict, validator);
    }

    public static boolean isValid(int port) {
        return 1 <= port && port <= 65535;
    }
}

