/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.support;

import java.io.IOException;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.persistent.PersistentTaskParams;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public class SecurityMigrationTaskParams
implements PersistentTaskParams {
    public static final String TASK_NAME = "security-migration";
    private final int migrationVersion;
    private final boolean migrationNeeded;
    public static final ConstructingObjectParser<SecurityMigrationTaskParams, Void> PARSER = new ConstructingObjectParser("security-migration", true, arr -> new SecurityMigrationTaskParams((Integer)arr[0], arr[1] == null || (Boolean)arr[1] != false));

    public SecurityMigrationTaskParams(int migrationVersion, boolean migrationNeeded) {
        this.migrationVersion = migrationVersion;
        this.migrationNeeded = migrationNeeded;
    }

    public SecurityMigrationTaskParams(StreamInput in) throws IOException {
        this.migrationVersion = in.readInt();
        this.migrationNeeded = in.getTransportVersion().onOrAfter(TransportVersions.V_8_15_0) ? in.readBoolean() : true;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeInt(this.migrationVersion);
        if (out.getTransportVersion().onOrAfter(TransportVersions.V_8_15_0)) {
            out.writeBoolean(this.migrationNeeded);
        }
    }

    @Override
    public String getWriteableName() {
        return TASK_NAME;
    }

    @Override
    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersions.V_8_15_0;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("migration_version", this.migrationVersion);
        builder.field("migration_needed", this.migrationNeeded);
        builder.endObject();
        return builder;
    }

    public static SecurityMigrationTaskParams fromXContent(XContentParser parser) {
        return PARSER.apply(parser, null);
    }

    public int getMigrationVersion() {
        return this.migrationVersion;
    }

    public boolean isMigrationNeeded() {
        return this.migrationNeeded;
    }

    static {
        PARSER.declareInt(ConstructingObjectParser.constructorArg(), new ParseField("migration_version", new String[0]));
        PARSER.declareBoolean(ConstructingObjectParser.optionalConstructorArg(), new ParseField("migration_needed", new String[0]));
    }
}

