/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.authc.ldap.support;

import com.unboundid.ldap.sdk.SearchScope;
import java.util.Locale;
import org.elasticsearch.common.Strings;

public enum LdapSearchScope {
    BASE(SearchScope.BASE),
    ONE_LEVEL(SearchScope.ONE),
    SUB_TREE(SearchScope.SUB);

    private final SearchScope scope;

    private LdapSearchScope(SearchScope scope) {
        this.scope = scope;
    }

    public SearchScope scope() {
        return this.scope;
    }

    public static LdapSearchScope resolve(String scope, LdapSearchScope defaultScope) {
        if (Strings.isNullOrEmpty(scope)) {
            return defaultScope;
        }
        return switch (scope.toLowerCase(Locale.ENGLISH)) {
            case "base", "object" -> BASE;
            case "one_level" -> ONE_LEVEL;
            case "sub_tree" -> SUB_TREE;
            default -> throw new IllegalArgumentException("unknown search scope [" + scope + "]");
        };
    }
}

