/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.action;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.tasks.BaseTasksResponse;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.xpack.core.ml.action.JobTaskRequest;

public class KillProcessAction
extends ActionType<Response> {
    public static final KillProcessAction INSTANCE = new KillProcessAction();
    public static final String NAME = "cluster:internal/xpack/ml/job/kill/process";

    private KillProcessAction() {
        super(NAME);
    }

    public static class Response
    extends BaseTasksResponse
    implements Writeable {
        private final boolean killed;

        public Response(StreamInput in) throws IOException {
            super(in);
            this.killed = in.readBoolean();
        }

        public Response(boolean killed) {
            super(null, null);
            this.killed = killed;
        }

        public boolean isKilled() {
            return this.killed;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeBoolean(this.killed);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Response response = (Response)o;
            return this.killed == response.killed;
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.killed);
        }
    }

    public static class Request
    extends JobTaskRequest<Request> {
        public Request(String jobId) {
            super(jobId);
        }

        public Request(StreamInput in) throws IOException {
            super(in);
        }
    }
}

