/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ccr.action;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.master.MasterNodeReadRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.ccr.AutoFollowMetadata;

public class GetAutoFollowPatternAction
extends ActionType<Response> {
    public static final String NAME = "cluster:admin/xpack/ccr/auto_follow_pattern/get";
    public static final GetAutoFollowPatternAction INSTANCE = new GetAutoFollowPatternAction();

    private GetAutoFollowPatternAction() {
        super(NAME);
    }

    public static class Response
    extends ActionResponse
    implements ToXContentObject {
        private final Map<String, AutoFollowMetadata.AutoFollowPattern> autoFollowPatterns;

        public Response(Map<String, AutoFollowMetadata.AutoFollowPattern> autoFollowPatterns) {
            this.autoFollowPatterns = autoFollowPatterns;
        }

        public Map<String, AutoFollowMetadata.AutoFollowPattern> getAutoFollowPatterns() {
            return this.autoFollowPatterns;
        }

        public Response(StreamInput in) throws IOException {
            this.autoFollowPatterns = in.readMap(AutoFollowMetadata.AutoFollowPattern::readFrom);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeMap(this.autoFollowPatterns, StreamOutput::writeWriteable);
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.startArray("patterns");
            for (Map.Entry<String, AutoFollowMetadata.AutoFollowPattern> entry : this.autoFollowPatterns.entrySet()) {
                builder.startObject();
                builder.field("name", entry.getKey());
                builder.startObject("pattern");
                entry.getValue().toXContent(builder, params);
                builder.endObject();
                builder.endObject();
            }
            builder.endArray();
            builder.endObject();
            return builder;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Response response = (Response)o;
            return Objects.equals(this.autoFollowPatterns, response.autoFollowPatterns);
        }

        public int hashCode() {
            return Objects.hash(this.autoFollowPatterns);
        }
    }

    public static class Request
    extends MasterNodeReadRequest<Request> {
        private String name;

        public Request(TimeValue masterNodeTimeout) {
            super(masterNodeTimeout);
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.name = in.readOptionalString();
        }

        @Override
        public ActionRequestValidationException validate() {
            return null;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeOptionalString(this.name);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Request request = (Request)o;
            return Objects.equals(this.name, request.name);
        }

        public int hashCode() {
            return Objects.hash(this.name);
        }
    }
}

