/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.license;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.TransportMasterNodeReadAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.license.GetBasicStatusRequest;
import org.elasticsearch.license.GetBasicStatusResponse;
import org.elasticsearch.license.License;
import org.elasticsearch.license.LicensesMetadata;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportGetBasicStatusAction
extends TransportMasterNodeReadAction<GetBasicStatusRequest, GetBasicStatusResponse> {
    @Inject
    public TransportGetBasicStatusAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters) {
        super("cluster:admin/xpack/license/basic_status", transportService, clusterService, threadPool, actionFilters, GetBasicStatusRequest::new, GetBasicStatusResponse::new, EsExecutors.DIRECT_EXECUTOR_SERVICE);
    }

    @Override
    protected void masterOperation(Task task, GetBasicStatusRequest request, ClusterState state, ActionListener<GetBasicStatusResponse> listener) throws Exception {
        LicensesMetadata licensesMetadata = (LicensesMetadata)state.metadata().custom("licenses");
        if (licensesMetadata == null) {
            listener.onResponse(new GetBasicStatusResponse(true));
        } else {
            License license = licensesMetadata.getLicense();
            listener.onResponse(new GetBasicStatusResponse(license == null || !License.LicenseType.isBasic(license.type())));
        }
    }

    @Override
    protected ClusterBlockException checkBlock(GetBasicStatusRequest request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_READ);
    }
}

