/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.ingest.common;

import java.lang.ref.SoftReference;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.cluster.metadata.ProjectId;
import org.elasticsearch.common.settings.SettingsException;
import org.elasticsearch.common.time.DateFormatter;
import org.elasticsearch.common.util.LocaleUtils;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.ingest.AbstractProcessor;
import org.elasticsearch.ingest.ConfigurationUtils;
import org.elasticsearch.ingest.IngestDocument;
import org.elasticsearch.ingest.Processor;
import org.elasticsearch.ingest.common.DateFormat;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.script.TemplateScript;

public final class DateProcessor
extends AbstractProcessor {
    public static final String TYPE = "date";
    static final String DEFAULT_TARGET_FIELD = "@timestamp";
    static final String DEFAULT_OUTPUT_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSSXXX";
    private final DateFormatter formatter;
    private final TemplateScript.Factory timezone;
    private final TemplateScript.Factory locale;
    private final String field;
    private final String targetField;
    private final List<String> formats;
    private final List<BiFunction<ZoneId, Locale, Function<String, ZonedDateTime>>> dateParsers;
    private final String outputFormat;

    DateProcessor(String tag, String description, @Nullable TemplateScript.Factory timezone, @Nullable TemplateScript.Factory locale, String field, List<String> formats, String targetField) {
        this(tag, description, timezone, locale, field, formats, targetField, DEFAULT_OUTPUT_FORMAT);
    }

    DateProcessor(String tag, String description, @Nullable TemplateScript.Factory timezone, @Nullable TemplateScript.Factory locale, String field, List<String> formats, String targetField, String outputFormat) {
        super(tag, description);
        this.timezone = timezone;
        this.locale = locale;
        this.field = field;
        this.targetField = targetField;
        this.formats = formats;
        this.dateParsers = new ArrayList<BiFunction<ZoneId, Locale, Function<String, ZonedDateTime>>>(this.formats.size());
        for (String format : formats) {
            DateFormat dateFormat = DateFormat.fromString(format);
            this.dateParsers.add((documentTimezone, documentLocale) -> Cache.INSTANCE.getOrCompute(new Cache.Key(format, (ZoneId)documentTimezone, (Locale)documentLocale), () -> dateFormat.getFunction(format, (ZoneId)documentTimezone, (Locale)documentLocale)));
        }
        this.outputFormat = outputFormat;
        this.formatter = DateFormatter.forPattern(this.outputFormat);
    }

    @Override
    public IngestDocument execute(IngestDocument document) {
        Locale documentLocale;
        ZoneId documentTimezone;
        Object obj = document.getFieldValue(this.field, Object.class);
        String value = null;
        if (obj != null) {
            value = obj.toString();
        }
        try {
            documentTimezone = this.getTimezone(document);
            documentLocale = this.getLocale(document);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("unable to parse date [" + value + "]", e);
        }
        ZonedDateTime dateTime = null;
        Exception lastException = null;
        for (BiFunction<ZoneId, Locale, Function<String, ZonedDateTime>> dateParser : this.dateParsers) {
            try {
                dateTime = dateParser.apply(documentTimezone, documentLocale).apply(value);
                break;
            }
            catch (Exception e) {
                lastException = ExceptionsHelper.useOrSuppress(lastException, e);
            }
        }
        if (dateTime == null) {
            throw new IllegalArgumentException("unable to parse date [" + value + "]", lastException);
        }
        document.setFieldValue(this.targetField, this.formatter.format(dateTime));
        return document;
    }

    @Override
    public String getType() {
        return TYPE;
    }

    ZoneId getTimezone(IngestDocument document) {
        String value;
        String string = value = this.timezone == null ? null : document.renderTemplate(this.timezone);
        if (value == null) {
            return ZoneOffset.UTC;
        }
        return ZoneId.of(value);
    }

    Locale getLocale(IngestDocument document) {
        String value;
        String string = value = this.locale == null ? null : document.renderTemplate(this.locale);
        if (value == null) {
            return Locale.ENGLISH;
        }
        return LocaleUtils.parse(value);
    }

    String getField() {
        return this.field;
    }

    String getTargetField() {
        return this.targetField;
    }

    List<String> getFormats() {
        return this.formats;
    }

    String getOutputFormat() {
        return this.outputFormat;
    }

    static final class Cache {
        private static final String CACHE_CAPACITY_SETTING = "es.ingest.date_processor.cache_capacity";
        static final Cache INSTANCE;
        private final ConcurrentMap<Key, SoftReference<Function<String, ZonedDateTime>>> map;
        private final int capacity;

        Cache(int capacity) {
            if (capacity <= 0) {
                throw new IllegalArgumentException("cache capacity must be a value greater than 0 but was " + capacity);
            }
            this.capacity = capacity;
            this.map = ConcurrentCollections.newConcurrentMapWithAggressiveConcurrency(this.capacity);
        }

        Function<String, ZonedDateTime> getOrCompute(Key key, Supplier<Function<String, ZonedDateTime>> supplier) {
            Function<String, ZonedDateTime> fn;
            SoftReference element = (SoftReference)this.map.get(key);
            if (element != null && (fn = (Function<String, ZonedDateTime>)element.get()) != null) {
                return fn;
            }
            if (this.map.size() >= this.capacity) {
                this.map.clear();
            }
            fn = supplier.get();
            this.map.put(key, new SoftReference<Function<String, ZonedDateTime>>(fn));
            return fn;
        }

        static {
            String cacheSizeStr = System.getProperty(CACHE_CAPACITY_SETTING, "256");
            try {
                INSTANCE = new Cache(Integer.parseInt(cacheSizeStr));
            }
            catch (NumberFormatException e) {
                throw new SettingsException("{} must be a valid number but was [{}]", CACHE_CAPACITY_SETTING, cacheSizeStr);
            }
        }

        record Key(String format, ZoneId zoneId, Locale locale) {
        }
    }

    public static final class Factory
    implements Processor.Factory {
        private final ScriptService scriptService;

        public Factory(ScriptService scriptService) {
            this.scriptService = scriptService;
        }

        @Override
        public DateProcessor create(Map<String, Processor.Factory> registry, String tag, String description, Map<String, Object> config, ProjectId projectId) throws Exception {
            String field = ConfigurationUtils.readStringProperty(DateProcessor.TYPE, tag, config, "field");
            String targetField = ConfigurationUtils.readStringProperty(DateProcessor.TYPE, tag, config, "target_field", DateProcessor.DEFAULT_TARGET_FIELD);
            String timezoneString = ConfigurationUtils.readOptionalStringProperty(DateProcessor.TYPE, tag, config, "timezone");
            TemplateScript.Factory compiledTimezoneTemplate = null;
            if (timezoneString != null) {
                compiledTimezoneTemplate = ConfigurationUtils.compileTemplate(DateProcessor.TYPE, tag, "timezone", timezoneString, this.scriptService);
            }
            String localeString = ConfigurationUtils.readOptionalStringProperty(DateProcessor.TYPE, tag, config, "locale");
            TemplateScript.Factory compiledLocaleTemplate = null;
            if (localeString != null) {
                compiledLocaleTemplate = ConfigurationUtils.compileTemplate(DateProcessor.TYPE, tag, "locale", localeString, this.scriptService);
            }
            List<String> formats = ConfigurationUtils.readList(DateProcessor.TYPE, tag, config, "formats");
            String outputFormat = ConfigurationUtils.readStringProperty(DateProcessor.TYPE, tag, config, "output_format", DateProcessor.DEFAULT_OUTPUT_FORMAT);
            try {
                DateFormatter.forPattern(outputFormat);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("invalid output format [" + outputFormat + "]", e);
            }
            return new DateProcessor(tag, description, compiledTimezoneTemplate, compiledLocaleTemplate, field, formats, targetField, outputFormat);
        }
    }
}

