/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.codec.vectors.es818;

import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.KnnFieldVectorsWriter;
import org.apache.lucene.codecs.KnnVectorsReader;
import org.apache.lucene.codecs.KnnVectorsWriter;
import org.apache.lucene.codecs.hnsw.FlatFieldVectorsWriter;
import org.apache.lucene.codecs.hnsw.FlatVectorsWriter;
import org.apache.lucene.codecs.lucene95.OrdToDocDISIReaderConfiguration;
import org.apache.lucene.codecs.perfield.PerFieldKnnVectorsFormat;
import org.apache.lucene.index.DocsWithFieldSet;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FloatVectorValues;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.KnnVectorValues;
import org.apache.lucene.index.MergeState;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.index.Sorter;
import org.apache.lucene.index.VectorEncoding;
import org.apache.lucene.index.VectorSimilarityFunction;
import org.apache.lucene.internal.hppc.FloatArrayList;
import org.apache.lucene.search.VectorScorer;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.VectorUtil;
import org.apache.lucene.util.hnsw.CloseableRandomVectorScorerSupplier;
import org.apache.lucene.util.hnsw.RandomVectorScorerSupplier;
import org.apache.lucene.util.hnsw.UpdateableRandomVectorScorer;
import org.elasticsearch.core.SuppressForbidden;
import org.elasticsearch.index.codec.vectors.BQSpaceUtils;
import org.elasticsearch.index.codec.vectors.BQVectorUtils;
import org.elasticsearch.index.codec.vectors.OptimizedScalarQuantizer;
import org.elasticsearch.index.codec.vectors.es818.BinarizedByteVectorValues;
import org.elasticsearch.index.codec.vectors.es818.ES818BinaryFlatVectorsScorer;
import org.elasticsearch.index.codec.vectors.es818.ES818BinaryQuantizedVectorsReader;
import org.elasticsearch.index.codec.vectors.es818.OffHeapBinarizedVectorValues;

@SuppressForbidden(reason="Lucene classes")
public class ES818BinaryQuantizedVectorsWriter
extends FlatVectorsWriter {
    private static final long SHALLOW_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(ES818BinaryQuantizedVectorsWriter.class);
    private final SegmentWriteState segmentWriteState;
    private final List<FieldWriter> fields = new ArrayList<FieldWriter>();
    private final IndexOutput meta;
    private final IndexOutput binarizedVectorData;
    private final FlatVectorsWriter rawVectorDelegate;
    private final ES818BinaryFlatVectorsScorer vectorsScorer;
    private boolean finished;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected ES818BinaryQuantizedVectorsWriter(ES818BinaryFlatVectorsScorer vectorsScorer, FlatVectorsWriter rawVectorDelegate, SegmentWriteState state) throws IOException {
        super(vectorsScorer);
        this.vectorsScorer = vectorsScorer;
        this.segmentWriteState = state;
        String metaFileName = IndexFileNames.segmentFileName(state.segmentInfo.name, state.segmentSuffix, "vemb");
        String binarizedVectorDataFileName = IndexFileNames.segmentFileName(state.segmentInfo.name, state.segmentSuffix, "veb");
        this.rawVectorDelegate = rawVectorDelegate;
        boolean success = false;
        try {
            this.meta = state.directory.createOutput(metaFileName, state.context);
            this.binarizedVectorData = state.directory.createOutput(binarizedVectorDataFileName, state.context);
            CodecUtil.writeIndexHeader(this.meta, "ES818BinaryQuantizedVectorsFormatMeta", 0, state.segmentInfo.getId(), state.segmentSuffix);
            CodecUtil.writeIndexHeader(this.binarizedVectorData, "ES818BinaryQuantizedVectorsFormatData", 0, state.segmentInfo.getId(), state.segmentSuffix);
            return;
        }
        catch (Throwable throwable) {
            if (success) throw throwable;
            IOUtils.closeWhileHandlingException(this);
            throw throwable;
        }
    }

    @Override
    public FlatFieldVectorsWriter<?> addField(FieldInfo fieldInfo) throws IOException {
        KnnFieldVectorsWriter rawVectorDelegate = this.rawVectorDelegate.addField(fieldInfo);
        if (fieldInfo.getVectorEncoding().equals((Object)VectorEncoding.FLOAT32)) {
            FieldWriter fieldWriter = new FieldWriter(fieldInfo, (FlatFieldVectorsWriter<float[]>)rawVectorDelegate);
            this.fields.add(fieldWriter);
            return fieldWriter;
        }
        return rawVectorDelegate;
    }

    @Override
    public void flush(int maxDoc, Sorter.DocMap sortMap) throws IOException {
        this.rawVectorDelegate.flush(maxDoc, sortMap);
        for (FieldWriter field : this.fields) {
            if (VectorSimilarityFunction.COSINE == field.fieldInfo.getVectorSimilarityFunction()) {
                field.normalizeVectors();
            }
            int vectorCount = field.flatFieldVectorsWriter.getVectors().size();
            float[] clusterCenter = new float[field.dimensionSums.length];
            if (vectorCount > 0) {
                for (int i = 0; i < field.dimensionSums.length; ++i) {
                    clusterCenter[i] = field.dimensionSums[i] / (float)vectorCount;
                }
                if (VectorSimilarityFunction.COSINE == field.fieldInfo.getVectorSimilarityFunction()) {
                    VectorUtil.l2normalize(clusterCenter);
                }
            }
            if (this.segmentWriteState.infoStream.isEnabled("BVEC")) {
                this.segmentWriteState.infoStream.message("BVEC", "Vectors' count:" + vectorCount);
            }
            OptimizedScalarQuantizer quantizer = new OptimizedScalarQuantizer(field.fieldInfo.getVectorSimilarityFunction());
            if (sortMap == null) {
                this.writeField(field, clusterCenter, maxDoc, quantizer);
            } else {
                this.writeSortingField(field, clusterCenter, maxDoc, sortMap, quantizer);
            }
            field.finish();
        }
    }

    private void writeField(FieldWriter fieldData, float[] clusterCenter, int maxDoc, OptimizedScalarQuantizer quantizer) throws IOException {
        long vectorDataOffset = this.binarizedVectorData.alignFilePointer(4);
        this.writeBinarizedVectors(fieldData, clusterCenter, quantizer);
        long vectorDataLength = this.binarizedVectorData.getFilePointer() - vectorDataOffset;
        float centroidDp = fieldData.getVectors().size() > 0 ? VectorUtil.dotProduct(clusterCenter, clusterCenter) : 0.0f;
        this.writeMeta(fieldData.fieldInfo, maxDoc, vectorDataOffset, vectorDataLength, clusterCenter, centroidDp, fieldData.getDocsWithFieldSet());
    }

    private void writeBinarizedVectors(FieldWriter fieldData, float[] clusterCenter, OptimizedScalarQuantizer scalarQuantizer) throws IOException {
        int discreteDims = BQVectorUtils.discretize(fieldData.fieldInfo.getVectorDimension(), 64);
        int[] quantizationScratch = new int[discreteDims];
        byte[] vector = new byte[discreteDims / 8];
        float[] scratch = new float[fieldData.fieldInfo.getVectorDimension()];
        for (int i = 0; i < fieldData.getVectors().size(); ++i) {
            float[] v = fieldData.getVectors().get(i);
            OptimizedScalarQuantizer.QuantizationResult corrections = scalarQuantizer.scalarQuantize(v, scratch, quantizationScratch, (byte)1, clusterCenter);
            BQVectorUtils.packAsBinary(quantizationScratch, vector);
            this.binarizedVectorData.writeBytes(vector, vector.length);
            this.binarizedVectorData.writeInt(Float.floatToIntBits(corrections.lowerInterval()));
            this.binarizedVectorData.writeInt(Float.floatToIntBits(corrections.upperInterval()));
            this.binarizedVectorData.writeInt(Float.floatToIntBits(corrections.additionalCorrection()));
            assert (corrections.quantizedComponentSum() >= 0 && corrections.quantizedComponentSum() <= 65535);
            this.binarizedVectorData.writeShort((short)corrections.quantizedComponentSum());
        }
    }

    private void writeSortingField(FieldWriter fieldData, float[] clusterCenter, int maxDoc, Sorter.DocMap sortMap, OptimizedScalarQuantizer scalarQuantizer) throws IOException {
        int[] ordMap = new int[fieldData.getDocsWithFieldSet().cardinality()];
        DocsWithFieldSet newDocsWithField = new DocsWithFieldSet();
        ES818BinaryQuantizedVectorsWriter.mapOldOrdToNewOrd(fieldData.getDocsWithFieldSet(), sortMap, null, ordMap, newDocsWithField);
        long vectorDataOffset = this.binarizedVectorData.alignFilePointer(4);
        this.writeSortedBinarizedVectors(fieldData, clusterCenter, ordMap, scalarQuantizer);
        long quantizedVectorLength = this.binarizedVectorData.getFilePointer() - vectorDataOffset;
        float centroidDp = VectorUtil.dotProduct(clusterCenter, clusterCenter);
        this.writeMeta(fieldData.fieldInfo, maxDoc, vectorDataOffset, quantizedVectorLength, clusterCenter, centroidDp, newDocsWithField);
    }

    private void writeSortedBinarizedVectors(FieldWriter fieldData, float[] clusterCenter, int[] ordMap, OptimizedScalarQuantizer scalarQuantizer) throws IOException {
        int discreteDims = BQVectorUtils.discretize(fieldData.fieldInfo.getVectorDimension(), 64);
        int[] quantizationScratch = new int[discreteDims];
        byte[] vector = new byte[discreteDims / 8];
        float[] scratch = new float[fieldData.fieldInfo.getVectorDimension()];
        for (int ordinal : ordMap) {
            float[] v = fieldData.getVectors().get(ordinal);
            OptimizedScalarQuantizer.QuantizationResult corrections = scalarQuantizer.scalarQuantize(v, scratch, quantizationScratch, (byte)1, clusterCenter);
            BQVectorUtils.packAsBinary(quantizationScratch, vector);
            this.binarizedVectorData.writeBytes(vector, vector.length);
            this.binarizedVectorData.writeInt(Float.floatToIntBits(corrections.lowerInterval()));
            this.binarizedVectorData.writeInt(Float.floatToIntBits(corrections.upperInterval()));
            this.binarizedVectorData.writeInt(Float.floatToIntBits(corrections.additionalCorrection()));
            assert (corrections.quantizedComponentSum() >= 0 && corrections.quantizedComponentSum() <= 65535);
            this.binarizedVectorData.writeShort((short)corrections.quantizedComponentSum());
        }
    }

    private void writeMeta(FieldInfo field, int maxDoc, long vectorDataOffset, long vectorDataLength, float[] clusterCenter, float centroidDp, DocsWithFieldSet docsWithField) throws IOException {
        this.meta.writeInt(field.number);
        this.meta.writeInt(field.getVectorEncoding().ordinal());
        this.meta.writeInt(field.getVectorSimilarityFunction().ordinal());
        this.meta.writeVInt(field.getVectorDimension());
        this.meta.writeVLong(vectorDataOffset);
        this.meta.writeVLong(vectorDataLength);
        int count = docsWithField.cardinality();
        this.meta.writeVInt(count);
        if (count > 0) {
            ByteBuffer buffer = ByteBuffer.allocate(field.getVectorDimension() * 4).order(ByteOrder.LITTLE_ENDIAN);
            buffer.asFloatBuffer().put(clusterCenter);
            this.meta.writeBytes(buffer.array(), buffer.array().length);
            this.meta.writeInt(Float.floatToIntBits(centroidDp));
        }
        OrdToDocDISIReaderConfiguration.writeStoredMeta(16, this.meta, this.binarizedVectorData, count, maxDoc, docsWithField);
    }

    @Override
    public void finish() throws IOException {
        if (this.finished) {
            throw new IllegalStateException("already finished");
        }
        this.finished = true;
        this.rawVectorDelegate.finish();
        if (this.meta != null) {
            this.meta.writeInt(-1);
            CodecUtil.writeFooter(this.meta);
        }
        if (this.binarizedVectorData != null) {
            CodecUtil.writeFooter(this.binarizedVectorData);
        }
    }

    @Override
    public void mergeOneField(FieldInfo fieldInfo, MergeState mergeState) throws IOException {
        if (fieldInfo.getVectorEncoding().equals((Object)VectorEncoding.FLOAT32)) {
            float[] mergedCentroid = new float[fieldInfo.getVectorDimension()];
            int vectorCount = ES818BinaryQuantizedVectorsWriter.mergeAndRecalculateCentroids(mergeState, fieldInfo, mergedCentroid);
            this.rawVectorDelegate.mergeOneField(fieldInfo, mergeState);
            float[] centroid = mergedCentroid;
            if (this.segmentWriteState.infoStream.isEnabled("BVEC")) {
                this.segmentWriteState.infoStream.message("BVEC", "Vectors' count:" + vectorCount);
            }
            FloatVectorValues floatVectorValues = KnnVectorsWriter.MergedVectorValues.mergeFloatVectorValues(fieldInfo, mergeState);
            if (fieldInfo.getVectorSimilarityFunction() == VectorSimilarityFunction.COSINE) {
                floatVectorValues = new NormalizedFloatVectorValues(floatVectorValues);
            }
            BinarizedFloatVectorValues binarizedVectorValues = new BinarizedFloatVectorValues(floatVectorValues, new OptimizedScalarQuantizer(fieldInfo.getVectorSimilarityFunction()), centroid);
            long vectorDataOffset = this.binarizedVectorData.alignFilePointer(4);
            DocsWithFieldSet docsWithField = ES818BinaryQuantizedVectorsWriter.writeBinarizedVectorData(this.binarizedVectorData, binarizedVectorValues);
            long vectorDataLength = this.binarizedVectorData.getFilePointer() - vectorDataOffset;
            float centroidDp = docsWithField.cardinality() > 0 ? VectorUtil.dotProduct(centroid, centroid) : 0.0f;
            this.writeMeta(fieldInfo, this.segmentWriteState.segmentInfo.maxDoc(), vectorDataOffset, vectorDataLength, centroid, centroidDp, docsWithField);
        } else {
            this.rawVectorDelegate.mergeOneField(fieldInfo, mergeState);
        }
    }

    static DocsWithFieldSet writeBinarizedVectorAndQueryData(IndexOutput binarizedVectorData, IndexOutput binarizedQueryData, FloatVectorValues floatVectorValues, float[] centroid, OptimizedScalarQuantizer binaryQuantizer) throws IOException {
        int discretizedDimension = BQVectorUtils.discretize(floatVectorValues.dimension(), 64);
        DocsWithFieldSet docsWithField = new DocsWithFieldSet();
        int[][] quantizationScratch = new int[2][floatVectorValues.dimension()];
        byte[] toIndex = new byte[discretizedDimension / 8];
        byte[] toQuery = new byte[discretizedDimension / 8 * 4];
        KnnVectorValues.DocIndexIterator iterator = floatVectorValues.iterator();
        float[] scratch = new float[floatVectorValues.dimension()];
        int docV = iterator.nextDoc();
        while (docV != Integer.MAX_VALUE) {
            OptimizedScalarQuantizer.QuantizationResult[] r = binaryQuantizer.multiScalarQuantize(floatVectorValues.vectorValue(iterator.index()), scratch, quantizationScratch, new byte[]{1, 4}, centroid);
            BQVectorUtils.packAsBinary(quantizationScratch[0], toIndex);
            binarizedVectorData.writeBytes(toIndex, toIndex.length);
            binarizedVectorData.writeInt(Float.floatToIntBits(r[0].lowerInterval()));
            binarizedVectorData.writeInt(Float.floatToIntBits(r[0].upperInterval()));
            binarizedVectorData.writeInt(Float.floatToIntBits(r[0].additionalCorrection()));
            assert (r[0].quantizedComponentSum() >= 0 && r[0].quantizedComponentSum() <= 65535);
            binarizedVectorData.writeShort((short)r[0].quantizedComponentSum());
            docsWithField.add(docV);
            BQSpaceUtils.transposeHalfByte(quantizationScratch[1], toQuery);
            binarizedQueryData.writeBytes(toQuery, toQuery.length);
            binarizedQueryData.writeInt(Float.floatToIntBits(r[1].lowerInterval()));
            binarizedQueryData.writeInt(Float.floatToIntBits(r[1].upperInterval()));
            binarizedQueryData.writeInt(Float.floatToIntBits(r[1].additionalCorrection()));
            assert (r[1].quantizedComponentSum() >= 0 && r[1].quantizedComponentSum() <= 65535);
            binarizedQueryData.writeShort((short)r[1].quantizedComponentSum());
            docV = iterator.nextDoc();
        }
        return docsWithField;
    }

    static DocsWithFieldSet writeBinarizedVectorData(IndexOutput output, BinarizedByteVectorValues binarizedByteVectorValues) throws IOException {
        DocsWithFieldSet docsWithField = new DocsWithFieldSet();
        KnnVectorValues.DocIndexIterator iterator = binarizedByteVectorValues.iterator();
        int docV = iterator.nextDoc();
        while (docV != Integer.MAX_VALUE) {
            byte[] binaryValue = binarizedByteVectorValues.vectorValue(iterator.index());
            output.writeBytes(binaryValue, binaryValue.length);
            OptimizedScalarQuantizer.QuantizationResult corrections = binarizedByteVectorValues.getCorrectiveTerms(iterator.index());
            output.writeInt(Float.floatToIntBits(corrections.lowerInterval()));
            output.writeInt(Float.floatToIntBits(corrections.upperInterval()));
            output.writeInt(Float.floatToIntBits(corrections.additionalCorrection()));
            assert (corrections.quantizedComponentSum() >= 0 && corrections.quantizedComponentSum() <= 65535);
            output.writeShort((short)corrections.quantizedComponentSum());
            docsWithField.add(docV);
            docV = iterator.nextDoc();
        }
        return docsWithField;
    }

    @Override
    public CloseableRandomVectorScorerSupplier mergeOneFieldToIndex(FieldInfo fieldInfo, MergeState mergeState) throws IOException {
        if (fieldInfo.getVectorEncoding().equals((Object)VectorEncoding.FLOAT32)) {
            float cDotC;
            float[] mergedCentroid = new float[fieldInfo.getVectorDimension()];
            int vectorCount = ES818BinaryQuantizedVectorsWriter.mergeAndRecalculateCentroids(mergeState, fieldInfo, mergedCentroid);
            this.rawVectorDelegate.mergeOneField(fieldInfo, mergeState);
            float[] centroid = mergedCentroid;
            float f = cDotC = vectorCount > 0 ? VectorUtil.dotProduct(centroid, centroid) : 0.0f;
            if (this.segmentWriteState.infoStream.isEnabled("BVEC")) {
                this.segmentWriteState.infoStream.message("BVEC", "Vectors' count:" + vectorCount);
            }
            return this.mergeOneFieldToIndex(this.segmentWriteState, fieldInfo, mergeState, centroid, cDotC);
        }
        return this.rawVectorDelegate.mergeOneFieldToIndex(fieldInfo, mergeState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CloseableRandomVectorScorerSupplier mergeOneFieldToIndex(SegmentWriteState segmentWriteState, FieldInfo fieldInfo, MergeState mergeState, float[] centroid, float cDotC) throws IOException {
        BinarizedCloseableRandomVectorScorerSupplier binarizedCloseableRandomVectorScorerSupplier;
        block8: {
            long vectorDataOffset = this.binarizedVectorData.alignFilePointer(4);
            IndexInput binarizedDataInput = null;
            IndexInput binarizedScoreDataInput = null;
            IndexOutput tempQuantizedVectorData = null;
            IndexOutput tempScoreQuantizedVectorData = null;
            boolean success = false;
            OptimizedScalarQuantizer quantizer = new OptimizedScalarQuantizer(fieldInfo.getVectorSimilarityFunction());
            try {
                tempQuantizedVectorData = segmentWriteState.directory.createTempOutput(this.binarizedVectorData.getName(), "temp", segmentWriteState.context);
                tempScoreQuantizedVectorData = segmentWriteState.directory.createTempOutput(this.binarizedVectorData.getName(), "score_temp", segmentWriteState.context);
                String tempQuantizedVectorDataName = tempQuantizedVectorData.getName();
                String tempScoreQuantizedVectorDataName = tempScoreQuantizedVectorData.getName();
                FloatVectorValues floatVectorValues = KnnVectorsWriter.MergedVectorValues.mergeFloatVectorValues(fieldInfo, mergeState);
                if (fieldInfo.getVectorSimilarityFunction() == VectorSimilarityFunction.COSINE) {
                    floatVectorValues = new NormalizedFloatVectorValues(floatVectorValues);
                }
                DocsWithFieldSet docsWithField = ES818BinaryQuantizedVectorsWriter.writeBinarizedVectorAndQueryData(tempQuantizedVectorData, tempScoreQuantizedVectorData, floatVectorValues, centroid, quantizer);
                CodecUtil.writeFooter(tempQuantizedVectorData);
                IOUtils.close(tempQuantizedVectorData);
                binarizedDataInput = segmentWriteState.directory.openInput(tempQuantizedVectorData.getName(), segmentWriteState.context);
                this.binarizedVectorData.copyBytes(binarizedDataInput, binarizedDataInput.length() - (long)CodecUtil.footerLength());
                long vectorDataLength = this.binarizedVectorData.getFilePointer() - vectorDataOffset;
                CodecUtil.retrieveChecksum(binarizedDataInput);
                CodecUtil.writeFooter(tempScoreQuantizedVectorData);
                IOUtils.close(tempScoreQuantizedVectorData);
                binarizedScoreDataInput = segmentWriteState.directory.openInput(tempScoreQuantizedVectorData.getName(), segmentWriteState.context);
                this.writeMeta(fieldInfo, segmentWriteState.segmentInfo.maxDoc(), vectorDataOffset, vectorDataLength, centroid, cDotC, docsWithField);
                success = true;
                IndexInput finalBinarizedDataInput = binarizedDataInput;
                IndexInput finalBinarizedScoreDataInput = binarizedScoreDataInput;
                OffHeapBinarizedVectorValues.DenseOffHeapVectorValues vectorValues = new OffHeapBinarizedVectorValues.DenseOffHeapVectorValues(fieldInfo.getVectorDimension(), docsWithField.cardinality(), centroid, cDotC, quantizer, fieldInfo.getVectorSimilarityFunction(), this.vectorsScorer, finalBinarizedDataInput);
                RandomVectorScorerSupplier scorerSupplier = this.vectorsScorer.getRandomVectorScorerSupplier(fieldInfo.getVectorSimilarityFunction(), new OffHeapBinarizedQueryVectorValues(finalBinarizedScoreDataInput, fieldInfo.getVectorDimension(), docsWithField.cardinality()), vectorValues);
                binarizedCloseableRandomVectorScorerSupplier = new BinarizedCloseableRandomVectorScorerSupplier(scorerSupplier, vectorValues, () -> {
                    IOUtils.close(finalBinarizedDataInput, finalBinarizedScoreDataInput);
                    IOUtils.deleteFilesIgnoringExceptions(segmentWriteState.directory, tempQuantizedVectorDataName, tempScoreQuantizedVectorDataName);
                });
                if (success) break block8;
            }
            catch (Throwable throwable) {
                if (!success) {
                    IOUtils.closeWhileHandlingException(tempQuantizedVectorData, tempScoreQuantizedVectorData, binarizedDataInput, binarizedScoreDataInput);
                    if (tempQuantizedVectorData != null) {
                        IOUtils.deleteFilesIgnoringExceptions(segmentWriteState.directory, tempQuantizedVectorData.getName());
                    }
                    if (tempScoreQuantizedVectorData != null) {
                        IOUtils.deleteFilesIgnoringExceptions(segmentWriteState.directory, tempScoreQuantizedVectorData.getName());
                    }
                }
                throw throwable;
            }
            IOUtils.closeWhileHandlingException(tempQuantizedVectorData, tempScoreQuantizedVectorData, binarizedDataInput, binarizedScoreDataInput);
            if (tempQuantizedVectorData != null) {
                IOUtils.deleteFilesIgnoringExceptions(segmentWriteState.directory, tempQuantizedVectorData.getName());
            }
            if (tempScoreQuantizedVectorData != null) {
                IOUtils.deleteFilesIgnoringExceptions(segmentWriteState.directory, tempScoreQuantizedVectorData.getName());
            }
        }
        return binarizedCloseableRandomVectorScorerSupplier;
    }

    @Override
    public void close() throws IOException {
        IOUtils.close(this.meta, this.binarizedVectorData, this.rawVectorDelegate);
    }

    static float[] getCentroid(KnnVectorsReader vectorsReader, String fieldName) {
        if (vectorsReader instanceof PerFieldKnnVectorsFormat.FieldsReader) {
            PerFieldKnnVectorsFormat.FieldsReader candidateReader = (PerFieldKnnVectorsFormat.FieldsReader)vectorsReader;
            vectorsReader = candidateReader.getFieldReader(fieldName);
        }
        if (vectorsReader instanceof ES818BinaryQuantizedVectorsReader) {
            ES818BinaryQuantizedVectorsReader reader = (ES818BinaryQuantizedVectorsReader)vectorsReader;
            return reader.getCentroid(fieldName);
        }
        return null;
    }

    static int mergeAndRecalculateCentroids(MergeState mergeState, FieldInfo fieldInfo, float[] mergedCentroid) throws IOException {
        boolean recalculate = false;
        int totalVectorCount = 0;
        for (int i = 0; i < mergeState.knnVectorsReaders.length; ++i) {
            KnnVectorsReader knnVectorsReader = mergeState.knnVectorsReaders[i];
            if (knnVectorsReader == null || knnVectorsReader.getFloatVectorValues(fieldInfo.name) == null) continue;
            float[] centroid = ES818BinaryQuantizedVectorsWriter.getCentroid(knnVectorsReader, fieldInfo.name);
            int vectorCount = knnVectorsReader.getFloatVectorValues(fieldInfo.name).size();
            if (vectorCount == 0) continue;
            totalVectorCount += vectorCount;
            if (centroid == null || mergeState.liveDocs[i] != null) {
                recalculate = true;
                break;
            }
            for (int j = 0; j < centroid.length; ++j) {
                int n = j;
                mergedCentroid[n] = mergedCentroid[n] + centroid[j] * (float)vectorCount;
            }
        }
        if (recalculate) {
            return ES818BinaryQuantizedVectorsWriter.calculateCentroid(mergeState, fieldInfo, mergedCentroid);
        }
        for (int j = 0; j < mergedCentroid.length; ++j) {
            mergedCentroid[j] = mergedCentroid[j] / (float)totalVectorCount;
        }
        if (fieldInfo.getVectorSimilarityFunction() == VectorSimilarityFunction.COSINE) {
            VectorUtil.l2normalize(mergedCentroid);
        }
        return totalVectorCount;
    }

    static int calculateCentroid(MergeState mergeState, FieldInfo fieldInfo, float[] centroid) throws IOException {
        int i;
        assert (fieldInfo.getVectorEncoding().equals((Object)VectorEncoding.FLOAT32));
        Arrays.fill(centroid, 0.0f);
        int count = 0;
        for (i = 0; i < mergeState.knnVectorsReaders.length; ++i) {
            FloatVectorValues vectorValues;
            KnnVectorsReader knnVectorsReader = mergeState.knnVectorsReaders[i];
            if (knnVectorsReader == null || (vectorValues = mergeState.knnVectorsReaders[i].getFloatVectorValues(fieldInfo.name)) == null) continue;
            KnnVectorValues.DocIndexIterator iterator = vectorValues.iterator();
            int doc = iterator.nextDoc();
            while (doc != Integer.MAX_VALUE) {
                ++count;
                float[] vector = vectorValues.vectorValue(iterator.index());
                for (int j = 0; j < vector.length; ++j) {
                    int n = j;
                    centroid[n] = centroid[n] + vector[j];
                }
                doc = iterator.nextDoc();
            }
        }
        if (count == 0) {
            return count;
        }
        i = 0;
        while (i < centroid.length) {
            int n = i++;
            centroid[n] = centroid[n] / (float)count;
        }
        if (fieldInfo.getVectorSimilarityFunction() == VectorSimilarityFunction.COSINE) {
            VectorUtil.l2normalize(centroid);
        }
        return count;
    }

    @Override
    public long ramBytesUsed() {
        long total = SHALLOW_RAM_BYTES_USED;
        for (FieldWriter field : this.fields) {
            total += field.ramBytesUsed();
        }
        return total;
    }

    static class FieldWriter
    extends FlatFieldVectorsWriter<float[]> {
        private static final long SHALLOW_SIZE = RamUsageEstimator.shallowSizeOfInstance(FieldWriter.class);
        private final FieldInfo fieldInfo;
        private boolean finished;
        private final FlatFieldVectorsWriter<float[]> flatFieldVectorsWriter;
        private final float[] dimensionSums;
        private final FloatArrayList magnitudes = new FloatArrayList();

        FieldWriter(FieldInfo fieldInfo, FlatFieldVectorsWriter<float[]> flatFieldVectorsWriter) {
            this.fieldInfo = fieldInfo;
            this.flatFieldVectorsWriter = flatFieldVectorsWriter;
            this.dimensionSums = new float[fieldInfo.getVectorDimension()];
        }

        @Override
        public List<float[]> getVectors() {
            return this.flatFieldVectorsWriter.getVectors();
        }

        public void normalizeVectors() {
            for (int i = 0; i < this.flatFieldVectorsWriter.getVectors().size(); ++i) {
                float[] vector = this.flatFieldVectorsWriter.getVectors().get(i);
                float magnitude = this.magnitudes.get(i);
                int j = 0;
                while (j < vector.length) {
                    int n = j++;
                    vector[n] = vector[n] / magnitude;
                }
            }
        }

        @Override
        public DocsWithFieldSet getDocsWithFieldSet() {
            return this.flatFieldVectorsWriter.getDocsWithFieldSet();
        }

        @Override
        public void finish() throws IOException {
            if (this.finished) {
                return;
            }
            assert (this.flatFieldVectorsWriter.isFinished());
            this.finished = true;
        }

        @Override
        public boolean isFinished() {
            return this.finished && this.flatFieldVectorsWriter.isFinished();
        }

        @Override
        public void addValue(int docID, float[] vectorValue) throws IOException {
            this.flatFieldVectorsWriter.addValue(docID, vectorValue);
            if (this.fieldInfo.getVectorSimilarityFunction() == VectorSimilarityFunction.COSINE) {
                float dp = VectorUtil.dotProduct(vectorValue, vectorValue);
                float divisor = (float)Math.sqrt(dp);
                this.magnitudes.add(divisor);
                for (int i = 0; i < vectorValue.length; ++i) {
                    int n = i;
                    this.dimensionSums[n] = this.dimensionSums[n] + vectorValue[i] / divisor;
                }
            } else {
                for (int i = 0; i < vectorValue.length; ++i) {
                    int n = i;
                    this.dimensionSums[n] = this.dimensionSums[n] + vectorValue[i];
                }
            }
        }

        @Override
        public float[] copyValue(float[] vectorValue) {
            throw new UnsupportedOperationException();
        }

        @Override
        public long ramBytesUsed() {
            long size = SHALLOW_SIZE;
            size += this.flatFieldVectorsWriter.ramBytesUsed();
            return size += this.magnitudes.ramBytesUsed();
        }
    }

    static final class NormalizedFloatVectorValues
    extends FloatVectorValues {
        private final FloatVectorValues values;
        private final float[] normalizedVector;

        NormalizedFloatVectorValues(FloatVectorValues values) {
            this.values = values;
            this.normalizedVector = new float[values.dimension()];
        }

        @Override
        public int dimension() {
            return this.values.dimension();
        }

        @Override
        public int size() {
            return this.values.size();
        }

        @Override
        public int ordToDoc(int ord) {
            return this.values.ordToDoc(ord);
        }

        @Override
        public float[] vectorValue(int ord) throws IOException {
            System.arraycopy(this.values.vectorValue(ord), 0, this.normalizedVector, 0, this.normalizedVector.length);
            VectorUtil.l2normalize(this.normalizedVector);
            return this.normalizedVector;
        }

        @Override
        public KnnVectorValues.DocIndexIterator iterator() {
            return this.values.iterator();
        }

        @Override
        public NormalizedFloatVectorValues copy() throws IOException {
            return new NormalizedFloatVectorValues(this.values.copy());
        }
    }

    static class BinarizedFloatVectorValues
    extends BinarizedByteVectorValues {
        private OptimizedScalarQuantizer.QuantizationResult corrections;
        private final byte[] binarized;
        private final int[] initQuantized;
        private final float[] centroid;
        private final float[] scratch;
        private final FloatVectorValues values;
        private final OptimizedScalarQuantizer quantizer;
        private int lastOrd = -1;

        BinarizedFloatVectorValues(FloatVectorValues delegate, OptimizedScalarQuantizer quantizer, float[] centroid) {
            this.values = delegate;
            this.quantizer = quantizer;
            this.binarized = new byte[BQVectorUtils.discretize(delegate.dimension(), 64) / 8];
            this.initQuantized = new int[delegate.dimension()];
            this.scratch = new float[delegate.dimension()];
            this.centroid = centroid;
        }

        @Override
        public OptimizedScalarQuantizer.QuantizationResult getCorrectiveTerms(int ord) {
            if (ord != this.lastOrd) {
                throw new IllegalStateException("attempt to retrieve corrective terms for different ord " + ord + " than the quantization was done for: " + this.lastOrd);
            }
            return this.corrections;
        }

        @Override
        public byte[] vectorValue(int ord) throws IOException {
            if (ord != this.lastOrd) {
                this.binarize(ord);
                this.lastOrd = ord;
            }
            return this.binarized;
        }

        @Override
        public int dimension() {
            return this.values.dimension();
        }

        @Override
        public OptimizedScalarQuantizer getQuantizer() {
            throw new UnsupportedOperationException();
        }

        @Override
        public float[] getCentroid() throws IOException {
            return this.centroid;
        }

        @Override
        public int size() {
            return this.values.size();
        }

        @Override
        public VectorScorer scorer(float[] target) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public BinarizedByteVectorValues copy() throws IOException {
            return new BinarizedFloatVectorValues(this.values.copy(), this.quantizer, this.centroid);
        }

        private void binarize(int ord) throws IOException {
            this.corrections = this.quantizer.scalarQuantize(this.values.vectorValue(ord), this.scratch, this.initQuantized, (byte)1, this.centroid);
            BQVectorUtils.packAsBinary(this.initQuantized, this.binarized);
        }

        @Override
        public KnnVectorValues.DocIndexIterator iterator() {
            return this.values.iterator();
        }

        @Override
        public int ordToDoc(int ord) {
            return this.values.ordToDoc(ord);
        }
    }

    static class OffHeapBinarizedQueryVectorValues {
        private final IndexInput slice;
        private final int dimension;
        private final int size;
        protected final byte[] binaryValue;
        protected final ByteBuffer byteBuffer;
        private final int byteSize;
        protected final float[] correctiveValues;
        private int lastOrd = -1;
        private int quantizedComponentSum;

        OffHeapBinarizedQueryVectorValues(IndexInput data, int dimension, int size) {
            this.slice = data;
            this.dimension = dimension;
            this.size = size;
            int binaryDimensions = BQVectorUtils.discretize(dimension, 64) / 8 * 4;
            this.byteBuffer = ByteBuffer.allocate(binaryDimensions);
            this.binaryValue = this.byteBuffer.array();
            this.correctiveValues = new float[3];
            this.byteSize = binaryDimensions + 12 + 2;
        }

        public OptimizedScalarQuantizer.QuantizationResult getCorrectiveTerms(int targetOrd) throws IOException {
            if (this.lastOrd == targetOrd) {
                return new OptimizedScalarQuantizer.QuantizationResult(this.correctiveValues[0], this.correctiveValues[1], this.correctiveValues[2], this.quantizedComponentSum);
            }
            this.vectorValue(targetOrd);
            return new OptimizedScalarQuantizer.QuantizationResult(this.correctiveValues[0], this.correctiveValues[1], this.correctiveValues[2], this.quantizedComponentSum);
        }

        int quantizedDimension() {
            return this.byteBuffer.array().length;
        }

        public int size() {
            return this.size;
        }

        public int dimension() {
            return this.dimension;
        }

        public OffHeapBinarizedQueryVectorValues copy() throws IOException {
            return new OffHeapBinarizedQueryVectorValues(this.slice.clone(), this.dimension, this.size);
        }

        public IndexInput getSlice() {
            return this.slice;
        }

        public byte[] vectorValue(int targetOrd) throws IOException {
            if (this.lastOrd == targetOrd) {
                return this.binaryValue;
            }
            this.slice.seek((long)targetOrd * (long)this.byteSize);
            this.slice.readBytes(this.binaryValue, 0, this.binaryValue.length);
            this.slice.readFloats(this.correctiveValues, 0, 3);
            this.quantizedComponentSum = Short.toUnsignedInt(this.slice.readShort());
            this.lastOrd = targetOrd;
            return this.binaryValue;
        }
    }

    static class BinarizedCloseableRandomVectorScorerSupplier
    implements CloseableRandomVectorScorerSupplier {
        private final RandomVectorScorerSupplier supplier;
        private final KnnVectorValues vectorValues;
        private final Closeable onClose;

        BinarizedCloseableRandomVectorScorerSupplier(RandomVectorScorerSupplier supplier, KnnVectorValues vectorValues, Closeable onClose) {
            this.supplier = supplier;
            this.onClose = onClose;
            this.vectorValues = vectorValues;
        }

        @Override
        public UpdateableRandomVectorScorer scorer() throws IOException {
            return this.supplier.scorer();
        }

        @Override
        public RandomVectorScorerSupplier copy() throws IOException {
            return this.supplier.copy();
        }

        @Override
        public void close() throws IOException {
            this.onClose.close();
        }

        @Override
        public int totalVectorCount() {
            return this.vectorValues.size();
        }
    }
}

