/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.admin.cluster.node.stats.NodeStats;
import org.elasticsearch.action.admin.cluster.node.stats.NodesStatsRequest;
import org.elasticsearch.action.admin.cluster.node.stats.NodesStatsRequestParameters;
import org.elasticsearch.action.admin.cluster.node.stats.NodesStatsResponse;
import org.elasticsearch.action.admin.indices.stats.IndicesStatsRequest;
import org.elasticsearch.action.admin.indices.stats.IndicesStatsResponse;
import org.elasticsearch.action.admin.indices.stats.ShardStats;
import org.elasticsearch.action.support.DefaultShardOperationFailedException;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.PlainActionFuture;
import org.elasticsearch.action.support.RefCountingRunnable;
import org.elasticsearch.action.support.ThreadedActionListener;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterInfo;
import org.elasticsearch.cluster.ClusterInfoService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.DiskUsage;
import org.elasticsearch.cluster.EstimatedHeapUsage;
import org.elasticsearch.cluster.EstimatedHeapUsageCollector;
import org.elasticsearch.cluster.NodeUsageStatsForThreadPools;
import org.elasticsearch.cluster.NodeUsageStatsForThreadPoolsCollector;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.allocation.DiskThresholdSettings;
import org.elasticsearch.cluster.routing.allocation.WriteLoadConstraintSettings;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.core.Strings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.shard.IndexingStats;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.store.StoreStats;
import org.elasticsearch.threadpool.ThreadPool;

public class InternalClusterInfoService
implements ClusterInfoService,
ClusterStateListener {
    private static final Logger logger = LogManager.getLogger(InternalClusterInfoService.class);
    public static final Setting<TimeValue> INTERNAL_CLUSTER_INFO_UPDATE_INTERVAL_SETTING = Setting.timeSetting("cluster.info.update.interval", TimeValue.timeValueSeconds(30L), TimeValue.timeValueSeconds(10L), Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<TimeValue> INTERNAL_CLUSTER_INFO_TIMEOUT_SETTING = Setting.positiveTimeSetting("cluster.info.update.timeout", TimeValue.timeValueSeconds(15L), Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<Boolean> CLUSTER_ROUTING_ALLOCATION_ESTIMATED_HEAP_THRESHOLD_DECIDER_ENABLED = Setting.boolSetting("cluster.routing.allocation.estimated_heap.threshold_enabled", false, Setting.Property.Dynamic, Setting.Property.NodeScope);
    private volatile boolean diskThresholdEnabled;
    private volatile boolean estimatedHeapThresholdEnabled;
    private volatile WriteLoadConstraintSettings.WriteLoadDeciderStatus writeLoadConstraintEnabled;
    private volatile TimeValue updateFrequency;
    private volatile TimeValue fetchTimeout;
    private volatile Map<String, DiskUsage> leastAvailableSpaceUsages;
    private volatile Map<String, DiskUsage> mostAvailableSpaceUsages;
    private volatile Map<String, ByteSizeValue> maxHeapPerNode;
    private volatile Map<String, Long> estimatedHeapUsagePerNode;
    private volatile Map<String, NodeUsageStatsForThreadPools> nodeThreadPoolUsageStatsPerNode;
    private volatile IndicesStatsSummary indicesStatsSummary;
    private final ThreadPool threadPool;
    private final Client client;
    private final Supplier<ClusterState> clusterStateSupplier;
    private final List<Consumer<ClusterInfo>> listeners = new CopyOnWriteArrayList<Consumer<ClusterInfo>>();
    private final Object mutex = new Object();
    private final List<ActionListener<ClusterInfo>> nextRefreshListeners = new ArrayList<ActionListener<ClusterInfo>>();
    private final EstimatedHeapUsageCollector estimatedHeapUsageCollector;
    private final NodeUsageStatsForThreadPoolsCollector nodeUsageStatsForThreadPoolsCollector;
    private AsyncRefresh currentRefresh;
    private RefreshScheduler refreshScheduler;

    public InternalClusterInfoService(Settings settings, ClusterService clusterService, ThreadPool threadPool, Client client, EstimatedHeapUsageCollector estimatedHeapUsageCollector, NodeUsageStatsForThreadPoolsCollector nodeUsageStatsForThreadPoolsCollector) {
        this.leastAvailableSpaceUsages = Map.of();
        this.mostAvailableSpaceUsages = Map.of();
        this.maxHeapPerNode = Map.of();
        this.estimatedHeapUsagePerNode = Map.of();
        this.nodeThreadPoolUsageStatsPerNode = Map.of();
        this.indicesStatsSummary = IndicesStatsSummary.EMPTY;
        this.threadPool = threadPool;
        this.client = client;
        this.estimatedHeapUsageCollector = estimatedHeapUsageCollector;
        this.nodeUsageStatsForThreadPoolsCollector = nodeUsageStatsForThreadPoolsCollector;
        this.updateFrequency = INTERNAL_CLUSTER_INFO_UPDATE_INTERVAL_SETTING.get(settings);
        this.fetchTimeout = INTERNAL_CLUSTER_INFO_TIMEOUT_SETTING.get(settings);
        this.diskThresholdEnabled = DiskThresholdSettings.CLUSTER_ROUTING_ALLOCATION_DISK_THRESHOLD_ENABLED_SETTING.get(settings);
        this.clusterStateSupplier = clusterService::state;
        ClusterSettings clusterSettings = clusterService.getClusterSettings();
        clusterSettings.addSettingsUpdateConsumer(INTERNAL_CLUSTER_INFO_TIMEOUT_SETTING, this::setFetchTimeout);
        clusterSettings.addSettingsUpdateConsumer(INTERNAL_CLUSTER_INFO_UPDATE_INTERVAL_SETTING, this::setUpdateFrequency);
        clusterSettings.addSettingsUpdateConsumer(DiskThresholdSettings.CLUSTER_ROUTING_ALLOCATION_DISK_THRESHOLD_ENABLED_SETTING, this::setDiskThresholdEnabled);
        clusterSettings.initializeAndWatch(CLUSTER_ROUTING_ALLOCATION_ESTIMATED_HEAP_THRESHOLD_DECIDER_ENABLED, this::setEstimatedHeapThresholdEnabled);
        clusterSettings.initializeAndWatch(WriteLoadConstraintSettings.WRITE_LOAD_DECIDER_ENABLED_SETTING, this::setWriteLoadConstraintEnabled);
    }

    private void setDiskThresholdEnabled(boolean diskThresholdEnabled) {
        this.diskThresholdEnabled = diskThresholdEnabled;
    }

    private void setEstimatedHeapThresholdEnabled(boolean estimatedHeapThresholdEnabled) {
        this.estimatedHeapThresholdEnabled = estimatedHeapThresholdEnabled;
    }

    private void setWriteLoadConstraintEnabled(WriteLoadConstraintSettings.WriteLoadDeciderStatus writeLoadConstraintEnabled) {
        this.writeLoadConstraintEnabled = writeLoadConstraintEnabled;
    }

    private void setFetchTimeout(TimeValue fetchTimeout) {
        this.fetchTimeout = fetchTimeout;
    }

    void setUpdateFrequency(TimeValue updateFrequency) {
        this.updateFrequency = updateFrequency;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clusterChanged(ClusterChangedEvent event) {
        Runnable newRefresh;
        Iterator<DiscoveryNode> iterator = this.mutex;
        synchronized (iterator) {
            if (!event.localNodeMaster()) {
                this.refreshScheduler = null;
                return;
            }
            if (this.refreshScheduler == null) {
                logger.trace("elected as master, scheduling cluster info update tasks");
                this.refreshScheduler = new RefreshScheduler();
                this.nextRefreshListeners.add(this.refreshScheduler.getListener());
            }
            newRefresh = this.getNewRefresh();
            assert (this.assertRefreshInvariant());
        }
        newRefresh.run();
        for (DiscoveryNode addedNode : event.nodesDelta().addedNodes()) {
            if (!addedNode.canContainData()) continue;
            this.refreshAsync(new PlainActionFuture<ClusterInfo>());
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onRefreshComplete(AsyncRefresh completedRefresh) {
        Runnable newRefresh;
        Object object = this.mutex;
        synchronized (object) {
            assert (this.currentRefresh == completedRefresh);
            this.currentRefresh = null;
            newRefresh = this.getNewRefresh();
            assert (this.assertRefreshInvariant());
        }
        newRefresh.run();
    }

    private Runnable getNewRefresh() {
        assert (Thread.holdsLock(this.mutex)) : "mutex not held";
        if (this.currentRefresh != null) {
            return () -> {};
        }
        if (this.nextRefreshListeners.isEmpty()) {
            return () -> {};
        }
        ArrayList<ActionListener<ClusterInfo>> thisRefreshListeners = new ArrayList<ActionListener<ClusterInfo>>(this.nextRefreshListeners);
        this.nextRefreshListeners.clear();
        this.currentRefresh = new AsyncRefresh(thisRefreshListeners);
        return this.currentRefresh::execute;
    }

    private boolean assertRefreshInvariant() {
        assert (Thread.holdsLock(this.mutex)) : "mutex not held";
        assert (this.nextRefreshListeners.isEmpty() || this.currentRefresh != null);
        return true;
    }

    @Override
    public ClusterInfo getClusterInfo() {
        IndicesStatsSummary indicesStatsSummary = this.indicesStatsSummary;
        HashMap<String, EstimatedHeapUsage> estimatedHeapUsages = new HashMap<String, EstimatedHeapUsage>();
        Map<String, ByteSizeValue> currentMaxHeapPerNode = this.maxHeapPerNode;
        currentMaxHeapPerNode.forEach((nodeId, maxHeapSize) -> {
            Long estimatedHeapUsage = this.estimatedHeapUsagePerNode.get(nodeId);
            if (estimatedHeapUsage != null) {
                estimatedHeapUsages.put((String)nodeId, new EstimatedHeapUsage((String)nodeId, maxHeapSize.getBytes(), estimatedHeapUsage));
            }
        });
        return new ClusterInfo(this.leastAvailableSpaceUsages, this.mostAvailableSpaceUsages, indicesStatsSummary.shardSizes, indicesStatsSummary.shardDataSetSizes, indicesStatsSummary.dataPath, indicesStatsSummary.reservedSpace, estimatedHeapUsages, this.nodeThreadPoolUsageStatsPerNode, indicesStatsSummary.shardWriteLoads(), currentMaxHeapPerNode);
    }

    List<NodeStats> adjustNodesStats(List<NodeStats> nodeStats) {
        return nodeStats;
    }

    ShardStats[] adjustShardStats(ShardStats[] shardStats) {
        return shardStats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void refreshAsync(ActionListener<ClusterInfo> future) {
        Runnable newRefresh;
        Object object = this.mutex;
        synchronized (object) {
            this.nextRefreshListeners.add(future);
            newRefresh = this.getNewRefresh();
            assert (this.assertRefreshInvariant());
        }
        newRefresh.run();
    }

    @Override
    public void addListener(Consumer<ClusterInfo> clusterInfoConsumer) {
        this.listeners.add(clusterInfoConsumer);
    }

    static void buildShardLevelInfo(ShardStats[] stats, Map<ShardId, Double> shardWriteLoads, Map<String, Long> shardSizes, Map<ShardId, Long> shardDataSetSizeBuilder, Map<ClusterInfo.NodeAndShard, String> dataPathByShard, Map<ClusterInfo.NodeAndPath, ClusterInfo.ReservedSpace.Builder> reservedSpaceByShard) {
        for (ShardStats s : stats) {
            double shardWriteLoad;
            IndexingStats indexingStats;
            ShardRouting shardRouting = s.getShardRouting();
            dataPathByShard.put(ClusterInfo.NodeAndShard.from(shardRouting), s.getDataPath());
            StoreStats storeStats = s.getStats().getStore();
            if (storeStats != null) {
                long size = storeStats.sizeInBytes();
                long dataSetSize = storeStats.totalDataSetSizeInBytes();
                long reserved = storeStats.reservedSizeInBytes();
                String shardIdentifier = ClusterInfo.shardIdentifierFromRouting(shardRouting);
                logger.trace("shard: {} size: {} reserved: {}", (Object)shardIdentifier, (Object)size, (Object)reserved);
                shardSizes.put(shardIdentifier, size);
                if (dataSetSize > shardDataSetSizeBuilder.getOrDefault(shardRouting.shardId(), -1L)) {
                    shardDataSetSizeBuilder.put(shardRouting.shardId(), dataSetSize);
                }
                if (reserved != -1L) {
                    ClusterInfo.ReservedSpace.Builder reservedSpaceBuilder = reservedSpaceByShard.computeIfAbsent(new ClusterInfo.NodeAndPath(shardRouting.currentNodeId(), s.getDataPath()), t -> new ClusterInfo.ReservedSpace.Builder());
                    reservedSpaceBuilder.add(shardRouting.shardId(), reserved);
                }
            }
            if ((indexingStats = s.getStats().getIndexing()) == null || !((shardWriteLoad = indexingStats.getTotal().getPeakWriteLoad()) > shardWriteLoads.getOrDefault(shardRouting.shardId(), -1.0))) continue;
            shardWriteLoads.put(shardRouting.shardId(), shardWriteLoad);
        }
    }

    private static void processNodeStatsArray(List<NodeStats> nodeStatsArray, Map<String, DiskUsage> newLeastAvailableUsages, Map<String, DiskUsage> newMostAvailableUsages, Map<String, ByteSizeValue> maxHeapPerNodeBuilder) {
        for (NodeStats nodeStats : nodeStatsArray) {
            DiskUsage mostAvailableUsage;
            DiskUsage leastAvailableUsage = DiskUsage.findLeastAvailablePath(nodeStats);
            if (leastAvailableUsage != null) {
                newLeastAvailableUsages.put(nodeStats.getNode().getId(), leastAvailableUsage);
            }
            if ((mostAvailableUsage = DiskUsage.findMostAvailable(nodeStats)) != null) {
                newMostAvailableUsages.put(nodeStats.getNode().getId(), mostAvailableUsage);
            }
            maxHeapPerNodeBuilder.put(nodeStats.getNode().getId(), nodeStats.getJvm().getMem().getHeapMax());
        }
    }

    private record IndicesStatsSummary(Map<String, Long> shardSizes, Map<ShardId, Long> shardDataSetSizes, Map<ClusterInfo.NodeAndShard, String> dataPath, Map<ClusterInfo.NodeAndPath, ClusterInfo.ReservedSpace> reservedSpace, Map<ShardId, Double> shardWriteLoads) {
        static final IndicesStatsSummary EMPTY = new IndicesStatsSummary(Map.of(), Map.of(), Map.of(), Map.of(), Map.of());
    }

    private class RefreshScheduler {
        private RefreshScheduler() {
        }

        ActionListener<ClusterInfo> getListener() {
            return ActionListener.running(() -> {
                if (this.shouldRefresh()) {
                    InternalClusterInfoService.this.threadPool.scheduleUnlessShuttingDown(InternalClusterInfoService.this.updateFrequency, EsExecutors.DIRECT_EXECUTOR_SERVICE, () -> {
                        if (this.shouldRefresh()) {
                            InternalClusterInfoService.this.refreshAsync(this.getListener());
                        }
                    });
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean shouldRefresh() {
            Object object = InternalClusterInfoService.this.mutex;
            synchronized (object) {
                return InternalClusterInfoService.this.refreshScheduler == this;
            }
        }
    }

    private class AsyncRefresh {
        private final List<ActionListener<ClusterInfo>> thisRefreshListeners;
        private final RefCountingRunnable fetchRefs = new RefCountingRunnable(this::callListeners);

        AsyncRefresh(List<ActionListener<ClusterInfo>> thisRefreshListeners) {
            this.thisRefreshListeners = thisRefreshListeners;
        }

        void execute() {
            logger.trace("starting async refresh");
            try (RefCountingRunnable ignoredRefs = this.fetchRefs;){
                this.maybeFetchIndicesStats(InternalClusterInfoService.this.diskThresholdEnabled || InternalClusterInfoService.this.writeLoadConstraintEnabled.atLeastLowThresholdEnabled());
                this.maybeFetchNodeStats(InternalClusterInfoService.this.diskThresholdEnabled || InternalClusterInfoService.this.estimatedHeapThresholdEnabled);
                this.maybeFetchNodesEstimatedHeapUsage(InternalClusterInfoService.this.estimatedHeapThresholdEnabled);
                this.maybeFetchNodesUsageStatsForThreadPools(InternalClusterInfoService.this.writeLoadConstraintEnabled);
            }
        }

        private void maybeFetchIndicesStats(boolean shouldFetch) {
            if (shouldFetch) {
                try (ThreadContext.StoredContext ignored = InternalClusterInfoService.this.threadPool.getThreadContext().clearTraceContext();){
                    this.fetchIndicesStats();
                }
            } else {
                logger.trace("skipping collecting disk usage info from cluster, notifying listeners with empty indices stats");
                InternalClusterInfoService.this.indicesStatsSummary = IndicesStatsSummary.EMPTY;
            }
        }

        private void maybeFetchNodeStats(boolean shouldFetch) {
            if (shouldFetch) {
                try (ThreadContext.StoredContext ignored = InternalClusterInfoService.this.threadPool.getThreadContext().clearTraceContext();){
                    this.fetchNodeStats();
                }
            } else {
                logger.trace("skipping collecting node stats from cluster, notifying listeners with empty node stats");
                InternalClusterInfoService.this.leastAvailableSpaceUsages = Map.of();
                InternalClusterInfoService.this.mostAvailableSpaceUsages = Map.of();
                InternalClusterInfoService.this.maxHeapPerNode = Map.of();
            }
        }

        private void maybeFetchNodesEstimatedHeapUsage(boolean shouldFetch) {
            if (shouldFetch) {
                try (ThreadContext.StoredContext ignored = InternalClusterInfoService.this.threadPool.getThreadContext().clearTraceContext();){
                    this.fetchNodesEstimatedHeapUsage();
                }
            } else {
                logger.trace("skipping collecting estimated heap usage from cluster, notifying listeners with empty estimated heap usage");
                InternalClusterInfoService.this.estimatedHeapUsagePerNode = Map.of();
            }
        }

        private void maybeFetchNodesUsageStatsForThreadPools(WriteLoadConstraintSettings.WriteLoadDeciderStatus writeLoadConstraintEnabled) {
            if (writeLoadConstraintEnabled.atLeastLowThresholdEnabled()) {
                try (ThreadContext.StoredContext ignored = InternalClusterInfoService.this.threadPool.getThreadContext().clearTraceContext();){
                    this.fetchNodesUsageStatsForThreadPools();
                }
            } else {
                logger.trace("skipping collecting shard/node write load estimates from cluster, feature currently disabled");
                InternalClusterInfoService.this.nodeThreadPoolUsageStatsPerNode = Map.of();
            }
        }

        private void fetchNodesUsageStatsForThreadPools() {
            InternalClusterInfoService.this.nodeUsageStatsForThreadPoolsCollector.collectUsageStats(InternalClusterInfoService.this.client, InternalClusterInfoService.this.clusterStateSupplier.get(), ActionListener.releaseAfter(new ActionListener<Map<String, NodeUsageStatsForThreadPools>>(){

                @Override
                public void onResponse(Map<String, NodeUsageStatsForThreadPools> threadPoolStats) {
                    InternalClusterInfoService.this.nodeThreadPoolUsageStatsPerNode = threadPoolStats;
                }

                @Override
                public void onFailure(Exception e) {
                    logger.warn("failed to fetch thread pool usage estimates for nodes", (Throwable)e);
                    InternalClusterInfoService.this.nodeThreadPoolUsageStatsPerNode = Map.of();
                }
            }, this.fetchRefs.acquire()));
        }

        private void fetchNodesEstimatedHeapUsage() {
            InternalClusterInfoService.this.estimatedHeapUsageCollector.collectClusterHeapUsage(ActionListener.releaseAfter(new ActionListener<Map<String, Long>>(){

                @Override
                public void onResponse(Map<String, Long> currentEstimatedHeapUsages) {
                    InternalClusterInfoService.this.estimatedHeapUsagePerNode = currentEstimatedHeapUsages;
                }

                @Override
                public void onFailure(Exception e) {
                    logger.warn("failed to fetch heap usage for nodes", (Throwable)e);
                    InternalClusterInfoService.this.estimatedHeapUsagePerNode = Map.of();
                }
            }, this.fetchRefs.acquire()));
        }

        private void fetchIndicesStats() {
            IndicesStatsRequest indicesStatsRequest = new IndicesStatsRequest();
            indicesStatsRequest.clear();
            if (InternalClusterInfoService.this.diskThresholdEnabled) {
                indicesStatsRequest.store(true);
            }
            if (InternalClusterInfoService.this.writeLoadConstraintEnabled.atLeastLowThresholdEnabled()) {
                indicesStatsRequest.indexing(true);
            }
            indicesStatsRequest.indicesOptions(IndicesOptions.STRICT_EXPAND_OPEN_CLOSED_HIDDEN);
            indicesStatsRequest.timeout(InternalClusterInfoService.this.fetchTimeout);
            InternalClusterInfoService.this.client.admin().indices().stats(indicesStatsRequest, new ThreadedActionListener<IndicesStatsResponse>(InternalClusterInfoService.this.threadPool.executor("management"), ActionListener.releaseAfter(new ActionListener<IndicesStatsResponse>(){

                @Override
                public void onResponse(IndicesStatsResponse indicesStatsResponse) {
                    logger.trace("received indices stats response");
                    if (indicesStatsResponse.getShardFailures().length > 0) {
                        HashSet<String> failedNodeIds = new HashSet<String>();
                        for (DefaultShardOperationFailedException shardFailure : indicesStatsResponse.getShardFailures()) {
                            Throwable throwable = shardFailure.getCause();
                            if (throwable instanceof FailedNodeException) {
                                FailedNodeException failedNodeException = (FailedNodeException)throwable;
                                if (failedNodeIds.add(failedNodeException.nodeId())) {
                                    logger.warn(() -> Strings.format("failed to retrieve shard stats from node [%s]", failedNodeException.nodeId()), failedNodeException.getCause());
                                }
                                logger.trace(() -> Strings.format("failed to retrieve stats for shard [%s][%s]", shardFailure.index(), shardFailure.shardId()), shardFailure.getCause());
                                continue;
                            }
                            logger.warn(() -> Strings.format("failed to retrieve stats for shard [%s][%s]", shardFailure.index(), shardFailure.shardId()), shardFailure.getCause());
                        }
                    }
                    ShardStats[] stats = indicesStatsResponse.getShards();
                    HashMap<ShardId, Double> shardWriteLoadByIdentifierBuilder = new HashMap<ShardId, Double>();
                    HashMap<String, Long> shardSizeByIdentifierBuilder = new HashMap<String, Long>();
                    HashMap<ShardId, Long> shardDataSetSizeBuilder = new HashMap<ShardId, Long>();
                    HashMap<ClusterInfo.NodeAndShard, String> dataPath = new HashMap<ClusterInfo.NodeAndShard, String>();
                    HashMap<ClusterInfo.NodeAndPath, ClusterInfo.ReservedSpace.Builder> reservedSpaceBuilders = new HashMap<ClusterInfo.NodeAndPath, ClusterInfo.ReservedSpace.Builder>();
                    InternalClusterInfoService.buildShardLevelInfo(InternalClusterInfoService.this.adjustShardStats(stats), shardWriteLoadByIdentifierBuilder, shardSizeByIdentifierBuilder, shardDataSetSizeBuilder, dataPath, reservedSpaceBuilders);
                    HashMap reservedSpace = new HashMap();
                    reservedSpaceBuilders.forEach((nodeAndPath, builder) -> reservedSpace.put(nodeAndPath, builder.build()));
                    InternalClusterInfoService.this.indicesStatsSummary = new IndicesStatsSummary(Map.copyOf(shardSizeByIdentifierBuilder), Map.copyOf(shardDataSetSizeBuilder), Map.copyOf(dataPath), Map.copyOf(reservedSpace), Map.copyOf(shardWriteLoadByIdentifierBuilder));
                }

                @Override
                public void onFailure(Exception e) {
                    if (e instanceof ClusterBlockException) {
                        logger.trace("failed to retrieve indices stats", (Throwable)e);
                    } else {
                        logger.warn("failed to retrieve indices stats", (Throwable)e);
                    }
                    InternalClusterInfoService.this.indicesStatsSummary = IndicesStatsSummary.EMPTY;
                }
            }, this.fetchRefs.acquire())));
        }

        private void fetchNodeStats() {
            NodesStatsRequest nodesStatsRequest = new NodesStatsRequest("data:true");
            nodesStatsRequest.setIncludeShardsStats(false);
            nodesStatsRequest.clear();
            nodesStatsRequest.addMetric(NodesStatsRequestParameters.Metric.FS);
            nodesStatsRequest.addMetric(NodesStatsRequestParameters.Metric.JVM);
            nodesStatsRequest.setTimeout(InternalClusterInfoService.this.fetchTimeout);
            InternalClusterInfoService.this.client.admin().cluster().nodesStats(nodesStatsRequest, ActionListener.releaseAfter(new ActionListener<NodesStatsResponse>(){

                @Override
                public void onResponse(NodesStatsResponse nodesStatsResponse) {
                    logger.trace("received node stats response");
                    for (FailedNodeException failure : nodesStatsResponse.failures()) {
                        logger.warn(() -> "failed to retrieve stats for node [" + failure.nodeId() + "]", failure.getCause());
                    }
                    HashMap<String, DiskUsage> leastAvailableUsagesBuilder = new HashMap<String, DiskUsage>();
                    HashMap<String, DiskUsage> mostAvailableUsagesBuilder = new HashMap<String, DiskUsage>();
                    HashMap<String, ByteSizeValue> maxHeapPerNodeBuilder = new HashMap<String, ByteSizeValue>();
                    InternalClusterInfoService.processNodeStatsArray(InternalClusterInfoService.this.adjustNodesStats(nodesStatsResponse.getNodes()), leastAvailableUsagesBuilder, mostAvailableUsagesBuilder, maxHeapPerNodeBuilder);
                    InternalClusterInfoService.this.leastAvailableSpaceUsages = Map.copyOf(leastAvailableUsagesBuilder);
                    InternalClusterInfoService.this.mostAvailableSpaceUsages = Map.copyOf(mostAvailableUsagesBuilder);
                    InternalClusterInfoService.this.maxHeapPerNode = Map.copyOf(maxHeapPerNodeBuilder);
                }

                @Override
                public void onFailure(Exception e) {
                    if (e instanceof ClusterBlockException) {
                        logger.trace("failed to retrieve node stats", (Throwable)e);
                    } else {
                        logger.warn("failed to retrieve node stats", (Throwable)e);
                    }
                    InternalClusterInfoService.this.leastAvailableSpaceUsages = Map.of();
                    InternalClusterInfoService.this.mostAvailableSpaceUsages = Map.of();
                    InternalClusterInfoService.this.maxHeapPerNode = Map.of();
                }
            }, this.fetchRefs.acquire()));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void callListeners() {
            try {
                logger.trace("stats all received, computing cluster info and notifying listeners");
                ClusterInfo clusterInfo = InternalClusterInfoService.this.getClusterInfo();
                boolean anyListeners = false;
                for (Consumer<ClusterInfo> consumer : InternalClusterInfoService.this.listeners) {
                    anyListeners = true;
                    try {
                        logger.trace("notifying [{}] of new cluster info", consumer);
                        consumer.accept(clusterInfo);
                    }
                    catch (Exception e) {
                        logger.info(() -> "failed to notify [" + String.valueOf(listener) + "] of new cluster info", (Throwable)e);
                    }
                }
                assert (anyListeners) : "expected to notify at least one listener";
                for (ActionListener actionListener : this.thisRefreshListeners) {
                    actionListener.onResponse(clusterInfo);
                }
            }
            finally {
                InternalClusterInfoService.this.onRefreshComplete(this);
            }
        }
    }
}

