/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.validate.query;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.function.LongSupplier;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Query;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ResolvedIndices;
import org.elasticsearch.action.admin.indices.validate.query.QueryExplanation;
import org.elasticsearch.action.admin.indices.validate.query.ShardValidateQueryRequest;
import org.elasticsearch.action.admin.indices.validate.query.ShardValidateQueryResponse;
import org.elasticsearch.action.admin.indices.validate.query.ValidateQueryRequest;
import org.elasticsearch.action.admin.indices.validate.query.ValidateQueryResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.DefaultShardOperationFailedException;
import org.elasticsearch.action.support.broadcast.BroadcastShardOperationFailedException;
import org.elasticsearch.action.support.broadcast.TransportBroadcastAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ProjectState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.project.ProjectResolver;
import org.elasticsearch.cluster.routing.ShardIterator;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.Randomness;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.index.query.ParsedQuery;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryShardException;
import org.elasticsearch.index.query.Rewriteable;
import org.elasticsearch.indices.IndexClosedException;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.search.SearchService;
import org.elasticsearch.search.internal.AliasFilter;
import org.elasticsearch.search.internal.SearchContext;
import org.elasticsearch.search.internal.ShardSearchRequest;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.RemoteClusterService;
import org.elasticsearch.transport.TransportService;

public class TransportValidateQueryAction
extends TransportBroadcastAction<ValidateQueryRequest, ValidateQueryResponse, ShardValidateQueryRequest, ShardValidateQueryResponse> {
    private final SearchService searchService;
    private final RemoteClusterService remoteClusterService;
    private final ProjectResolver projectResolver;

    @Inject
    public TransportValidateQueryAction(ClusterService clusterService, TransportService transportService, SearchService searchService, ActionFilters actionFilters, ProjectResolver projectResolver, IndexNameExpressionResolver indexNameExpressionResolver) {
        super("indices:admin/validate/query", clusterService, transportService, actionFilters, indexNameExpressionResolver, ValidateQueryRequest::new, ShardValidateQueryRequest::new, transportService.getThreadPool().executor("search"));
        this.searchService = searchService;
        this.remoteClusterService = transportService.getRemoteClusterService();
        this.projectResolver = projectResolver;
    }

    @Override
    protected void doExecute(Task task, ValidateQueryRequest request, ActionListener<ValidateQueryResponse> listener) {
        request.nowInMillis = System.currentTimeMillis();
        LongSupplier timeProvider = () -> request.nowInMillis;
        ProjectState project = this.getProjectState();
        ResolvedIndices resolvedIndices = ResolvedIndices.resolveWithIndicesRequest(request, project.metadata(), this.indexNameExpressionResolver, this.remoteClusterService, request.nowInMillis);
        ActionListener<QueryBuilder> rewriteListener = ActionListener.wrap(rewrittenQuery -> {
            request.query((QueryBuilder)rewrittenQuery);
            super.doExecute(task, request, listener);
        }, ex -> {
            if (ex instanceof IndexNotFoundException || ex instanceof IndexClosedException) {
                listener.onFailure((Exception)ex);
                return;
            }
            ArrayList<QueryExplanation> explanations = new ArrayList<QueryExplanation>();
            explanations.add(new QueryExplanation(null, -1, false, null, ex.getMessage()));
            listener.onResponse(new ValidateQueryResponse(false, explanations, 0, 0, 0, null));
        });
        if (request.query() == null) {
            rewriteListener.onResponse(request.query());
        } else {
            Rewriteable.rewriteAndFetch(request.query(), this.searchService.getRewriteContext(timeProvider, this.clusterService.state().getMinTransportVersion(), null, resolvedIndices, null, null), rewriteListener);
        }
    }

    private ProjectState getProjectState() {
        return this.projectResolver.getProjectState(this.clusterService.state());
    }

    @Override
    protected ShardValidateQueryRequest newShardRequest(int numShards, ShardRouting shard, ValidateQueryRequest request) {
        ProjectState projectState = this.getProjectState();
        Set<IndexNameExpressionResolver.ResolvedExpression> indicesAndAliases = this.indexNameExpressionResolver.resolveExpressions(projectState.metadata(), request.indices());
        AliasFilter aliasFilter = this.searchService.buildAliasFilter(projectState, shard.getIndexName(), indicesAndAliases);
        return new ShardValidateQueryRequest(shard.shardId(), aliasFilter, request);
    }

    @Override
    protected ShardValidateQueryResponse readShardResponse(StreamInput in) throws IOException {
        return new ShardValidateQueryResponse(in);
    }

    @Override
    protected List<ShardIterator> shards(ClusterState clusterState, ValidateQueryRequest request, String[] concreteIndices) {
        String routing = request.allShards() ? null : Integer.toString(Randomness.get().nextInt(1000));
        ProjectState project = this.getProjectState();
        Map<String, Set<String>> routingMap = this.indexNameExpressionResolver.resolveSearchRouting(project.metadata(), routing, request.indices());
        return this.clusterService.operationRouting().searchShards(project, concreteIndices, routingMap, "_local");
    }

    @Override
    protected ClusterBlockException checkGlobalBlock(ClusterState state, ValidateQueryRequest request) {
        return state.blocks().globalBlockedException(this.projectResolver.getProjectId(), ClusterBlockLevel.READ);
    }

    @Override
    protected ClusterBlockException checkRequestBlock(ClusterState state, ValidateQueryRequest countRequest, String[] concreteIndices) {
        return state.blocks().indicesBlockedException(this.projectResolver.getProjectId(), ClusterBlockLevel.READ, concreteIndices);
    }

    @Override
    protected ValidateQueryResponse newResponse(ValidateQueryRequest request, AtomicReferenceArray<?> shardsResponses, ClusterState clusterState) {
        int successfulShards = 0;
        int failedShards = 0;
        boolean valid = true;
        ArrayList<DefaultShardOperationFailedException> shardFailures = null;
        ArrayList<QueryExplanation> queryExplanations = null;
        for (int i = 0; i < shardsResponses.length(); ++i) {
            Object shardResponse = shardsResponses.get(i);
            if (shardResponse == null) continue;
            if (shardResponse instanceof BroadcastShardOperationFailedException) {
                ++failedShards;
                if (shardFailures == null) {
                    shardFailures = new ArrayList<DefaultShardOperationFailedException>();
                }
                shardFailures.add(new DefaultShardOperationFailedException((BroadcastShardOperationFailedException)shardResponse));
                continue;
            }
            ShardValidateQueryResponse validateQueryResponse = (ShardValidateQueryResponse)shardResponse;
            boolean bl = valid = valid && validateQueryResponse.isValid();
            if (request.explain() || request.rewrite() || request.allShards()) {
                if (queryExplanations == null) {
                    queryExplanations = new ArrayList<QueryExplanation>();
                }
                queryExplanations.add(new QueryExplanation(validateQueryResponse.getIndex(), request.allShards() ? validateQueryResponse.getShardId().getId() : -1, validateQueryResponse.isValid(), validateQueryResponse.getExplanation(), validateQueryResponse.getError()));
            }
            ++successfulShards;
        }
        return new ValidateQueryResponse(valid, queryExplanations, shardsResponses.length(), successfulShards, failedShards, shardFailures);
    }

    @Override
    protected ShardValidateQueryResponse shardOperation(ShardValidateQueryRequest request, Task task) throws IOException {
        boolean valid;
        String explanation = null;
        String error = null;
        ShardSearchRequest shardSearchLocalRequest = new ShardSearchRequest(request.shardId(), request.nowInMillis(), request.filteringAliases());
        try (SearchContext searchContext = this.searchService.createSearchContext(shardSearchLocalRequest, SearchService.NO_TIMEOUT);){
            ParsedQuery parsedQuery = searchContext.getSearchExecutionContext().toQuery(request.query());
            searchContext.parsedQuery(parsedQuery);
            searchContext.preProcess();
            valid = true;
            explanation = TransportValidateQueryAction.explain(searchContext, request.rewrite());
        }
        catch (ParsingException | QueryShardException e) {
            valid = false;
            error = e.getDetailedMessage();
        }
        catch (AssertionError e) {
            valid = false;
            error = ((Throwable)((Object)e)).getMessage();
        }
        return new ShardValidateQueryResponse(request.shardId(), valid, explanation, error);
    }

    private static String explain(SearchContext context, boolean rewritten) {
        Query query;
        Query query2 = query = rewritten ? context.rewrittenQuery() : context.query();
        if (rewritten && query instanceof MatchNoDocsQuery) {
            return context.parsedQuery().query().toString();
        }
        return query.toString();
    }
}

