/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.snapshot;

import co.elastic.clients.elasticsearch.snapshot.RepositorySettingsBase;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class AzureRepositorySettings
extends RepositorySettingsBase {
    @Nullable
    private final String basePath;
    @Nullable
    private final String client;
    @Nullable
    private final String container;
    @Nullable
    private final Integer deleteObjectsMaxSize;
    @Nullable
    private final String locationMode;
    @Nullable
    private final Integer maxConcurrentBatchDeletes;
    @Nullable
    private final Boolean readonly;
    public static final JsonpDeserializer<AzureRepositorySettings> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, AzureRepositorySettings::setupAzureRepositorySettingsDeserializer);

    private AzureRepositorySettings(Builder builder) {
        super(builder);
        this.basePath = builder.basePath;
        this.client = builder.client;
        this.container = builder.container;
        this.deleteObjectsMaxSize = builder.deleteObjectsMaxSize;
        this.locationMode = builder.locationMode;
        this.maxConcurrentBatchDeletes = builder.maxConcurrentBatchDeletes;
        this.readonly = builder.readonly;
    }

    public static AzureRepositorySettings of(Function<Builder, ObjectBuilder<AzureRepositorySettings>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final String basePath() {
        return this.basePath;
    }

    @Nullable
    public final String client() {
        return this.client;
    }

    @Nullable
    public final String container() {
        return this.container;
    }

    @Nullable
    public final Integer deleteObjectsMaxSize() {
        return this.deleteObjectsMaxSize;
    }

    @Nullable
    public final String locationMode() {
        return this.locationMode;
    }

    @Nullable
    public final Integer maxConcurrentBatchDeletes() {
        return this.maxConcurrentBatchDeletes;
    }

    @Nullable
    public final Boolean readonly() {
        return this.readonly;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.basePath != null) {
            generator.writeKey("base_path");
            generator.write(this.basePath);
        }
        if (this.client != null) {
            generator.writeKey("client");
            generator.write(this.client);
        }
        if (this.container != null) {
            generator.writeKey("container");
            generator.write(this.container);
        }
        if (this.deleteObjectsMaxSize != null) {
            generator.writeKey("delete_objects_max_size");
            generator.write(this.deleteObjectsMaxSize);
        }
        if (this.locationMode != null) {
            generator.writeKey("location_mode");
            generator.write(this.locationMode);
        }
        if (this.maxConcurrentBatchDeletes != null) {
            generator.writeKey("max_concurrent_batch_deletes");
            generator.write(this.maxConcurrentBatchDeletes);
        }
        if (this.readonly != null) {
            generator.writeKey("readonly");
            generator.write(this.readonly);
        }
    }

    protected static void setupAzureRepositorySettingsDeserializer(ObjectDeserializer<Builder> op) {
        RepositorySettingsBase.setupRepositorySettingsBaseDeserializer(op);
        op.add(Builder::basePath, JsonpDeserializer.stringDeserializer(), "base_path");
        op.add(Builder::client, JsonpDeserializer.stringDeserializer(), "client");
        op.add(Builder::container, JsonpDeserializer.stringDeserializer(), "container");
        op.add(Builder::deleteObjectsMaxSize, JsonpDeserializer.integerDeserializer(), "delete_objects_max_size");
        op.add(Builder::locationMode, JsonpDeserializer.stringDeserializer(), "location_mode");
        op.add(Builder::maxConcurrentBatchDeletes, JsonpDeserializer.integerDeserializer(), "max_concurrent_batch_deletes");
        op.add(Builder::readonly, JsonpDeserializer.booleanDeserializer(), "readonly");
    }

    public static class Builder
    extends RepositorySettingsBase.AbstractBuilder<Builder>
    implements ObjectBuilder<AzureRepositorySettings> {
        @Nullable
        private String basePath;
        @Nullable
        private String client;
        @Nullable
        private String container;
        @Nullable
        private Integer deleteObjectsMaxSize;
        @Nullable
        private String locationMode;
        @Nullable
        private Integer maxConcurrentBatchDeletes;
        @Nullable
        private Boolean readonly;

        public final Builder basePath(@Nullable String value) {
            this.basePath = value;
            return this;
        }

        public final Builder client(@Nullable String value) {
            this.client = value;
            return this;
        }

        public final Builder container(@Nullable String value) {
            this.container = value;
            return this;
        }

        public final Builder deleteObjectsMaxSize(@Nullable Integer value) {
            this.deleteObjectsMaxSize = value;
            return this;
        }

        public final Builder locationMode(@Nullable String value) {
            this.locationMode = value;
            return this;
        }

        public final Builder maxConcurrentBatchDeletes(@Nullable Integer value) {
            this.maxConcurrentBatchDeletes = value;
            return this;
        }

        public final Builder readonly(@Nullable Boolean value) {
            this.readonly = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public AzureRepositorySettings build() {
            this._checkSingleUse();
            return new AzureRepositorySettings(this);
        }
    }
}

