/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.connector;

import co.elastic.clients.elasticsearch.connector.CustomSchedulingConfigurationOverrides;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.DateTime;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class CustomScheduling
implements JsonpSerializable {
    private final CustomSchedulingConfigurationOverrides configurationOverrides;
    private final boolean enabled;
    private final String interval;
    @Nullable
    private final DateTime lastSynced;
    private final String name;
    public static final JsonpDeserializer<CustomScheduling> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, CustomScheduling::setupCustomSchedulingDeserializer);

    private CustomScheduling(Builder builder) {
        this.configurationOverrides = ApiTypeHelper.requireNonNull(builder.configurationOverrides, this, "configurationOverrides");
        this.enabled = ApiTypeHelper.requireNonNull(builder.enabled, (Object)this, "enabled", false);
        this.interval = ApiTypeHelper.requireNonNull(builder.interval, this, "interval");
        this.lastSynced = builder.lastSynced;
        this.name = ApiTypeHelper.requireNonNull(builder.name, this, "name");
    }

    public static CustomScheduling of(Function<Builder, ObjectBuilder<CustomScheduling>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final CustomSchedulingConfigurationOverrides configurationOverrides() {
        return this.configurationOverrides;
    }

    public final boolean enabled() {
        return this.enabled;
    }

    public final String interval() {
        return this.interval;
    }

    @Nullable
    public final DateTime lastSynced() {
        return this.lastSynced;
    }

    public final String name() {
        return this.name;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("configuration_overrides");
        this.configurationOverrides.serialize(generator, mapper);
        generator.writeKey("enabled");
        generator.write(this.enabled);
        generator.writeKey("interval");
        generator.write(this.interval);
        if (this.lastSynced != null) {
            generator.writeKey("last_synced");
            this.lastSynced.serialize(generator, mapper);
        }
        generator.writeKey("name");
        generator.write(this.name);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupCustomSchedulingDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::configurationOverrides, CustomSchedulingConfigurationOverrides._DESERIALIZER, "configuration_overrides");
        op.add(Builder::enabled, JsonpDeserializer.booleanDeserializer(), "enabled");
        op.add(Builder::interval, JsonpDeserializer.stringDeserializer(), "interval");
        op.add(Builder::lastSynced, DateTime._DESERIALIZER, "last_synced");
        op.add(Builder::name, JsonpDeserializer.stringDeserializer(), "name");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<CustomScheduling> {
        private CustomSchedulingConfigurationOverrides configurationOverrides;
        private Boolean enabled;
        private String interval;
        @Nullable
        private DateTime lastSynced;
        private String name;

        public final Builder configurationOverrides(CustomSchedulingConfigurationOverrides value) {
            this.configurationOverrides = value;
            return this;
        }

        public final Builder configurationOverrides(Function<CustomSchedulingConfigurationOverrides.Builder, ObjectBuilder<CustomSchedulingConfigurationOverrides>> fn) {
            return this.configurationOverrides(fn.apply(new CustomSchedulingConfigurationOverrides.Builder()).build());
        }

        public final Builder enabled(boolean value) {
            this.enabled = value;
            return this;
        }

        public final Builder interval(String value) {
            this.interval = value;
            return this;
        }

        public final Builder lastSynced(@Nullable DateTime value) {
            this.lastSynced = value;
            return this;
        }

        public final Builder name(String value) {
            this.name = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public CustomScheduling build() {
            this._checkSingleUse();
            return new CustomScheduling(this);
        }
    }
}

