"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.calcDateMathDiff = calcDateMathDiff;
var _datemath = _interopRequireDefault(require("@kbn/datemath"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Calculates difference between date math expressions in milliseconds.
 */
function calcDateMathDiff(start, end) {
  const now = new Date();
  const startMoment = _datemath.default.parse(start, {
    forceNow: now
  });
  const endMoment = _datemath.default.parse(end, {
    forceNow: now
  });
  if (!startMoment || !endMoment) {
    return undefined;
  }
  const result = endMoment.diff(startMoment, 'ms');
  return !isNaN(result) ? result : undefined;
}