"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getGeneralFilters = void 0;
var _lodash = require("lodash");
var _fp = require("lodash/fp");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getGeneralFilters = (filters, namespaceTypes) => {
  return Object.keys(filters).map(filterKey => {
    const value = (0, _fp.get)(filterKey, filters);
    if ((0, _lodash.isArray)(value) || value != null && value.trim() !== '') {
      const filtersByNamespace = namespaceTypes.map(namespace => {
        const fieldToSearch = filterKey === 'name' ? 'name.text' : filterKey === 'types' ? 'type' : filterKey;
        return (0, _lodash.isArray)(value) ? value.map(val => `${namespace}.attributes.${fieldToSearch}:${val}`).join(' OR ') : `${namespace}.attributes.${fieldToSearch}:${value}`;
      }).join(' OR ');
      return `(${filtersByNamespace})`;
    } else return null;
  }).filter(item => item != null).join(' AND ');
};
exports.getGeneralFilters = getGeneralFilters;