"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RuleActionUuid = exports.RuleActionTypeId = exports.RuleActionParams = exports.RuleActionId = exports.RuleActionGroup = exports.RuleActionCamel = exports.RuleActionArrayCamel = exports.RuleActionArray = exports.RuleActionAlertsFilter = exports.RuleAction = void 0;
var _securitysolutionIoTsTypes = require("@kbn/securitysolution-io-ts-types");
var t = _interopRequireWildcard(require("io-ts"));
var _saved_object_attributes = require("../saved_object_attributes");
var _frequency = require("../frequency");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RuleActionGroup = exports.RuleActionGroup = t.string;
const RuleActionId = exports.RuleActionId = t.string;
const RuleActionTypeId = exports.RuleActionTypeId = t.string;
const RuleActionUuid = exports.RuleActionUuid = _securitysolutionIoTsTypes.NonEmptyString;

/**
 * Params is an "object", since it is a type of RuleActionParams which is action templates.
 * @see x-pack/platform/plugins/shared/alerting/common/rule.ts
 */

const RuleActionParams = exports.RuleActionParams = _saved_object_attributes.saved_object_attributes;
const RuleActionAlertsFilter = exports.RuleActionAlertsFilter = t.partial({
  query: t.union([t.undefined, t.intersection([t.strict({
    kql: t.string,
    filters: t.array(t.intersection([t.type({
      meta: t.partial({
        alias: t.union([t.string, t.null]),
        disabled: t.boolean,
        negate: t.boolean,
        controlledBy: t.string,
        group: t.string,
        index: t.string,
        isMultiIndex: t.boolean,
        type: t.string,
        key: t.string,
        params: t.any,
        value: t.string
      })
    }), t.partial({
      $state: t.type({
        store: t.any
      }),
      query: t.record(t.string, t.any)
    })]))
  }), t.partial({
    dsl: t.string
  })])]),
  timeframe: t.union([t.undefined, t.strict({
    timezone: t.string,
    days: t.array(t.union([t.literal(1), t.literal(2), t.literal(3), t.literal(4), t.literal(5), t.literal(6), t.literal(7)])),
    hours: t.strict({
      start: t.string,
      end: t.string
    })
  })])
});
const RuleAction = exports.RuleAction = t.exact(t.intersection([t.type({
  group: RuleActionGroup,
  id: RuleActionId,
  action_type_id: RuleActionTypeId,
  params: RuleActionParams
}), t.partial({
  uuid: RuleActionUuid,
  alerts_filter: RuleActionAlertsFilter,
  frequency: _frequency.RuleActionFrequency
})]));
const RuleActionArray = exports.RuleActionArray = t.array(RuleAction);
const RuleActionCamel = exports.RuleActionCamel = t.exact(t.intersection([t.type({
  group: RuleActionGroup,
  id: RuleActionId,
  actionTypeId: RuleActionTypeId,
  params: RuleActionParams
}), t.partial({
  uuid: RuleActionUuid,
  alertsFilter: RuleActionAlertsFilter,
  frequency: _frequency.RuleActionFrequency
})]));
const RuleActionArrayCamel = exports.RuleActionArrayCamel = t.array(RuleActionCamel);