"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getExportTimelineByObjectIds = void 0;
var _fp = require("lodash/fp");
var _securitysolutionUtils = require("@kbn/securitysolution-utils");
var noteLib = _interopRequireWildcard(require("../../../saved_object/notes"));
var pinnedEventLib = _interopRequireWildcard(require("../../../saved_object/pinned_events"));
var _timelines = require("../../../saved_object/timelines");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getGlobalEventNotesByTimelineId = currentNotes => {
  const initialNotes = {
    eventNotes: [],
    globalNotes: []
  };
  return currentNotes.reduce((acc, note) => {
    if (note.eventId == null) {
      acc.globalNotes.push(note);
    } else {
      acc.eventNotes.push(note);
    }
    return acc;
  }, initialNotes);
};
const getPinnedEventsIdsByTimelineId = currentPinnedEvents => {
  var _currentPinnedEvents$;
  return (_currentPinnedEvents$ = currentPinnedEvents.map(event => event.eventId)) !== null && _currentPinnedEvents$ !== void 0 ? _currentPinnedEvents$ : [];
};
const getTimelinesFromObjects = async (request, ids) => {
  const {
    timelines,
    errors
  } = await (0, _timelines.getSelectedTimelines)(request, ids);
  const exportedIds = timelines.map(t => t.savedObjectId);
  const [notes, pinnedEvents] = await Promise.all([Promise.all(exportedIds.map(timelineId => noteLib.getNotesByTimelineId(request, timelineId))), Promise.all(exportedIds.map(timelineId => pinnedEventLib.getAllPinnedEventsByTimelineId(request, timelineId)))]);
  const myNotes = notes.reduce((acc, note) => [...acc, ...note], []);
  const myPinnedEventIds = pinnedEvents.reduce((acc, pinnedEventId) => [...acc, ...pinnedEventId], []);
  const myResponse = exportedIds.reduce((acc, timelineId) => {
    const myTimeline = timelines.find(t => t.savedObjectId === timelineId);
    if (myTimeline != null) {
      const timelineNotes = myNotes.filter(n => n.timelineId === timelineId);
      const timelinePinnedEventIds = myPinnedEventIds.filter(p => p.timelineId === timelineId);
      const exportedTimeline = (0, _fp.omit)(['status', 'excludedRowRendererIds'], myTimeline);
      return [...acc, {
        ...exportedTimeline,
        ...getGlobalEventNotesByTimelineId(timelineNotes),
        pinnedEventIds: getPinnedEventsIdsByTimelineId(timelinePinnedEventIds)
      }];
    }
    return acc;
  }, []);
  return [...myResponse, ...errors];
};
const getExportTimelineByObjectIds = async ({
  frameworkRequest,
  ids
}) => {
  const timeline = await getTimelinesFromObjects(frameworkRequest, ids);
  return (0, _securitysolutionUtils.transformDataToNdjson)(timeline);
};
exports.getExportTimelineByObjectIds = getExportTimelineByObjectIds;