"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSourceDocument = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Retrieves a source document by matching the provided `_id` and `_index`.
 */
const getSourceDocument = (sourceDocuments, id, index) => {
  const documents = sourceDocuments[id];
  if (!documents) {
    return undefined;
  }
  if (documents.length === 1) {
    return documents[0];
  }
  return documents.find(doc => doc._index === index);
};
exports.getSourceDocument = getSourceDocument;