"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ensureIndicesExistsForPolicies = void 0;
var _create_policy_datastreams = require("../../fleet_integration/handlers/create_policy_datastreams");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ensureIndicesExistsForPolicies = async endpointServices => {
  const logger = endpointServices.createLogger('startupPolicyIndicesChecker');
  const fleetServices = endpointServices.getInternalFleetServices();
  const soClient = fleetServices.savedObjects.createInternalUnscopedSoClient();
  const endpointPoliciesIds = await fleetServices.packagePolicy.listIds(soClient, {
    kuery: fleetServices.endpointPolicyKuery,
    perPage: 10000,
    spaceIds: ['*']
  });
  if (endpointPoliciesIds.items.length === 0) {
    logger.info(`Nothing to do. No endpoint policies found.`);
    return;
  }
  logger.info(`Checking to ensure [${endpointPoliciesIds.items.length}] endpoint policies have backing indices`);
  await (0, _create_policy_datastreams.createPolicyDataStreamsIfNeeded)({
    endpointServices,
    endpointPolicyIds: endpointPoliciesIds.items
  });
  logger.info(`Done checking endpoint policies have backing indices`);
};
exports.ensureIndicesExistsForPolicies = ensureIndicesExistsForPolicies;