"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StatefulTimeline = void 0;
var _fp = require("lodash/fp");
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _public = require("@kbn/timelines-plugin/public");
var _use_space_id = require("../../../common/hooks/use_space_id");
var _constants = require("../../../../common/constants");
var _use_experimental_features = require("../../../common/hooks/use_experimental_features");
var _store = require("../../store");
var _defaults = require("../../store/defaults");
var _model = require("../../../sourcerer/store/model");
var _header = require("../modal/header");
var _timeline = require("../../../../common/api/timeline");
var _use_selector = require("../../../common/hooks/use_selector");
var _store2 = require("../../../common/store");
var _helpers = require("./helpers");
var i18n = _interopRequireWildcard(require("./translations"));
var _tabs = require("./tabs");
var _styles = require("./styles");
var _use_full_screen = require("../../../common/containers/use_full_screen");
var _exit_full_screen = require("../../../common/components/exit_full_screen");
var _use_resolve_conflict = require("../../../common/hooks/use_resolve_conflict");
var _default_headers = require("./body/column_headers/default_headers");
var _use_selected_patterns = require("../../../data_view_manager/hooks/use_selected_patterns");
var _use_data_view = require("../../../data_view_manager/hooks/use_data_view");
var _context = require("./context");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/timelines/components/timeline/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const TimelineBody = _styledComponents.default.div`
  height: 100%;
  display: flex;
  flex-direction: column;
`;
const TimelineSavingProgressComponent = ({
  timelineId
}) => {
  const getTimeline = (0, _react.useMemo)(() => _store.timelineSelectors.getTimelineByIdSelector(), []);
  const isSaving = (0, _use_selector.useShallowEqualSelector)(state => {
    var _getTimeline;
    return ((_getTimeline = getTimeline(state, timelineId)) !== null && _getTimeline !== void 0 ? _getTimeline : _defaults.timelineDefaults).isSaving;
  });
  return isSaving ? /*#__PURE__*/_react.default.createElement(_eui.EuiProgress, {
    size: "s",
    color: "primary",
    position: "absolute",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 21
    }
  }) : null;
};
const TimelineSavingProgress = /*#__PURE__*/_react.default.memo(TimelineSavingProgressComponent);
const StatefulTimelineComponent = ({
  renderCellValue,
  rowRenderers,
  timelineId,
  openToggleRef
}) => {
  const dispatch = (0, _reactRedux.useDispatch)();
  const containerElement = (0, _react.useRef)(null);
  const getTimeline = (0, _react.useMemo)(() => _store.timelineSelectors.getTimelineByIdSelector(), []);
  const selectedPatternsSourcerer = (0, _reactRedux.useSelector)(state => {
    return _store2.sourcererSelectors.sourcererScopeSelectedPatterns(state, _model.SourcererScopeName.timeline);
  });
  const selectedDataViewIdSourcerer = (0, _reactRedux.useSelector)(state => {
    return _store2.sourcererSelectors.sourcererScopeSelectedDataViewId(state, _model.SourcererScopeName.timeline);
  });
  const {
    dataViewId: selectedDataViewIdTimeline,
    indexNames: selectedPatternsTimeline,
    savedObjectId,
    timelineType,
    description,
    initialized
  } = (0, _use_selector.useDeepEqualSelector)(state => {
    var _getTimeline2;
    return (0, _fp.pick)(['indexNames', 'dataViewId', 'savedObjectId', 'timelineType', 'description', 'initialized', 'show', 'activeTab'], (_getTimeline2 = getTimeline(state, timelineId)) !== null && _getTimeline2 !== void 0 ? _getTimeline2 : _defaults.timelineDefaults);
  });
  const {
    timelineFullScreen
  } = (0, _use_full_screen.useTimelineFullScreen)();
  const newDataViewPickerEnabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('newDataViewPickerEnabled');
  const spaceId = (0, _use_space_id.useSpaceId)();
  const experimentalSelectedPatterns = (0, _use_selected_patterns.useSelectedPatterns)(_model.SourcererScopeName.timeline);
  const {
    dataView: experimentalDataView,
    status
  } = (0, _use_data_view.useDataView)(_model.SourcererScopeName.timeline);
  const selectedDataViewId = (0, _react.useMemo)(() => {
    var _experimentalDataView;
    return newDataViewPickerEnabled ? (_experimentalDataView = experimentalDataView.id) !== null && _experimentalDataView !== void 0 ? _experimentalDataView : '' : selectedDataViewIdSourcerer;
  }, [experimentalDataView.id, newDataViewPickerEnabled, selectedDataViewIdSourcerer]);
  const selectedPatterns = (0, _react.useMemo)(() => newDataViewPickerEnabled ? experimentalSelectedPatterns : selectedPatternsSourcerer, [experimentalSelectedPatterns, newDataViewPickerEnabled, selectedPatternsSourcerer]);
  (0, _react.useEffect)(() => {
    if (!savedObjectId && !initialized) {
      dispatch(_store.timelineActions.createTimeline({
        id: timelineId,
        columns: _default_headers.defaultUdtHeaders,
        dataViewId: selectedDataViewId,
        indexNames: selectedPatterns,
        show: false,
        excludedRowRendererIds: _defaults.timelineDefaults.excludedRowRendererIds
      }));
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  const onSourcererChange = (0, _react.useCallback)(() => {
    if (
    // timeline not initialized, so this must be initial state and not user change
    !savedObjectId || selectedDataViewId == null ||
    // initial state will get set on create
    selectedDataViewIdTimeline === null && selectedPatternsTimeline.length === 0 ||
    // don't update if no change
    selectedDataViewIdTimeline === selectedDataViewId && selectedPatternsTimeline.sort().join() === selectedPatterns.sort().join()) {
      return;
    }
    // TODO: newDataViewPickerEnabled: With the new data view picker, we should not update the selected patterns
    // on timeline, as that prevents us from guiding the user to duplicate the data view or using the new alerts only dv
    if (selectedDataViewIdTimeline === `${_constants.DEFAULT_DATA_VIEW_ID}-${spaceId}` && selectedPatternsTimeline.length === 1 && selectedPatternsTimeline[0].includes(_constants.DEFAULT_ALERTS_INDEX)) {
      return;
    }
    dispatch(_store.timelineActions.updateDataView({
      dataViewId: selectedDataViewId,
      id: timelineId,
      indexNames: selectedPatterns
    }));
  }, [dispatch, savedObjectId, selectedDataViewId, selectedDataViewIdTimeline, selectedPatterns, selectedPatternsTimeline, spaceId, timelineId]);
  (0, _react.useEffect)(() => {
    // NOTE: dont dispatch sourcerer events until the status is ready - for the new picker
    if (newDataViewPickerEnabled && status !== 'ready') {
      return;
    }
    onSourcererChange();
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [selectedDataViewId, selectedPatterns, newDataViewPickerEnabled, status]);
  const onSkipFocusBeforeEventsTable = (0, _react.useCallback)(() => {
    var _containerElement$cur;
    const exitFullScreenButton = (_containerElement$cur = containerElement.current) === null || _containerElement$cur === void 0 ? void 0 : _containerElement$cur.querySelector(_exit_full_screen.EXIT_FULL_SCREEN_CLASS_NAME);
    if (exitFullScreenButton != null) {
      exitFullScreenButton.focus();
    } else {
      var _containerElement$cur2, _containerElement$cur3;
      (_containerElement$cur2 = containerElement.current) === null || _containerElement$cur2 === void 0 ? void 0 : (_containerElement$cur3 = _containerElement$cur2.querySelector('.globalFilterBar__addButton')) === null || _containerElement$cur3 === void 0 ? void 0 : _containerElement$cur3.focus();
    }
  }, [containerElement]);
  const onSkipFocusAfterEventsTable = (0, _react.useCallback)(() => {
    var _containerElement$cur4, _containerElement$cur5;
    (_containerElement$cur4 = containerElement.current) === null || _containerElement$cur4 === void 0 ? void 0 : (_containerElement$cur5 = _containerElement$cur4.querySelector(`.${_helpers.EVENTS_COUNT_BUTTON_CLASS_NAME}`)) === null || _containerElement$cur5 === void 0 ? void 0 : _containerElement$cur5.focus();
  }, [containerElement]);
  const onKeyDown = (0, _react.useCallback)(keyboardEvent => {
    if ((0, _public.isTab)(keyboardEvent)) {
      (0, _helpers.onTimelineTabKeyPressed)({
        containerElement: containerElement.current,
        keyboardEvent,
        onSkipFocusBeforeEventsTable,
        onSkipFocusAfterEventsTable
      });
    }
  }, [containerElement, onSkipFocusBeforeEventsTable, onSkipFocusAfterEventsTable]);
  const timelineContext = (0, _react.useMemo)(() => ({
    timelineId
  }), [timelineId]);
  const resolveConflictComponent = (0, _use_resolve_conflict.useResolveConflict)();
  return /*#__PURE__*/_react.default.createElement(_context.TimelineContext.Provider, {
    value: timelineContext,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 223,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_styles.TimelineContainer, {
    "data-test-subj": "timeline",
    "data-timeline-id": timelineId,
    onKeyDown: onKeyDown,
    ref: containerElement,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 224,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(TimelineSavingProgress, {
    timelineId: timelineId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 230,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(TimelineBody, {
    "data-test-subj": "timeline-body",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 231,
      columnNumber: 9
    }
  }, timelineType === _timeline.TimelineTypeEnum.template && /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: "accent",
    grow: false,
    paddingSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 233,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    color: "accent",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 234,
      columnNumber: 15
    }
  }, i18n.TIMELINE_TEMPLATE)), resolveConflictComponent, /*#__PURE__*/_react.default.createElement(_styles.HideShowContainer, {
    $isVisible: !timelineFullScreen,
    "data-test-subj": "timeline-hide-show-container",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 240,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_header.TimelineModalHeader, {
    timelineId: timelineId,
    openToggleRef: openToggleRef,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 244,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_tabs.TabsContent, {
    renderCellValue: renderCellValue,
    rowRenderers: rowRenderers,
    timelineId: timelineId,
    timelineType: timelineType,
    timelineDescription: description,
    timelineFullScreen: timelineFullScreen,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 247,
      columnNumber: 11
    }
  }))));
};
StatefulTimelineComponent.displayName = 'StatefulTimelineComponent';
const StatefulTimeline = exports.StatefulTimeline = /*#__PURE__*/_react.default.memo(StatefulTimelineComponent);