"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HIGHLIGHTED_DROP_TARGET_CLASS_NAME = exports.Empty = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _and_or_badge = require("../../../../common/components/and_or_badge");
var _add_data_provider_popover = require("./add_data_provider_popover");
var i18n = _interopRequireWildcard(require("./translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/timelines/components/timeline/data_providers/empty.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const HIGHLIGHTED_DROP_TARGET_CLASS_NAME = exports.HIGHLIGHTED_DROP_TARGET_CLASS_NAME = 'highlighted-drop-target';
const Text = (0, _styledComponents.default)(_eui.EuiText)`
  overflow: hidden;
  margin: 5px 0 5px 0;
  padding: 3px;
  white-space: nowrap;
`;
Text.displayName = 'Text';
const BadgeHighlighted = (0, _styledComponents.default)(_eui.EuiBadge)`
  height: 20px;
  margin: 0 5px 0 5px;
  maxwidth: 85px;
  minwidth: 85px;
`;
BadgeHighlighted.displayName = 'BadgeHighlighted';
const HighlightedBackground = _styledComponents.default.span`
  background-color: ${props => props.theme.eui.euiColorLightShade};
`;
HighlightedBackground.displayName = 'HighlightedBackground';
const EmptyContainer = _styledComponents.default.div`
  width: ${props => props.showSmallMsg ? '60px' : 'auto'};
  align-items: center;
  display: flex;
  flex-direction: column;
  flex-wrap: wrap;
  justify-content: center;
  user-select: none;
  align-content: center;
  ${props => props.showSmallMsg ? `
      border-right: 1px solid ${props.theme.eui.euiColorMediumShade};
      margin-right: 10px;
    ` : `
  min-height: 100px;
  + div {
    display: none !important;
   }
  `}
`;
EmptyContainer.displayName = 'EmptyContainer';
const NoWrap = _styledComponents.default.div`
  align-items: center;
  display: flex;
  flex-direction: row;
  flex-wrap: no-wrap;
`;
NoWrap.displayName = 'NoWrap';
/**
 * Prompts the user to drop anything with a facet count into the data providers section.
 */
const Empty = exports.Empty = /*#__PURE__*/_react.default.memo(({
  showSmallMsg = false,
  browserFields,
  timelineId
}) => /*#__PURE__*/_react.default.createElement(EmptyContainer, {
  className: "timeline-drop-area-empty",
  "data-test-subj": "empty",
  showSmallMsg: showSmallMsg,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 86,
    columnNumber: 3
  }
}, !showSmallMsg && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(NoWrap, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 93,
    columnNumber: 9
  }
}, /*#__PURE__*/_react.default.createElement(Text, {
  color: "subdued",
  size: "s",
  className: "timeline-drop-area-empty__text",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 94,
    columnNumber: 11
  }
}, i18n.DROP_ANYTHING), /*#__PURE__*/_react.default.createElement(HighlightedBackground, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 97,
    columnNumber: 11
  }
}, /*#__PURE__*/_react.default.createElement(BadgeHighlighted, {
  className: HIGHLIGHTED_DROP_TARGET_CLASS_NAME,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 98,
    columnNumber: 13
  }
}, i18n.HIGHLIGHTED)), /*#__PURE__*/_react.default.createElement(Text, {
  color: "subdued",
  size: "s",
  className: "timeline-drop-area-empty__text",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 102,
    columnNumber: 11
  }
}, i18n.HERE_TO_BUILD_AN), /*#__PURE__*/_react.default.createElement(_and_or_badge.AndOrBadge, {
  type: "or",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 105,
    columnNumber: 11
  }
}), /*#__PURE__*/_react.default.createElement(Text, {
  color: "subdued",
  size: "s",
  className: "timeline-drop-area-empty__text",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 106,
    columnNumber: 11
  }
}, i18n.QUERY)), /*#__PURE__*/_react.default.createElement(_add_data_provider_popover.AddDataProviderPopover, {
  browserFields: browserFields,
  timelineId: timelineId,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 111,
    columnNumber: 9
  }
})), showSmallMsg && /*#__PURE__*/_react.default.createElement(_and_or_badge.AndOrBadge, {
  type: "or",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 114,
    columnNumber: 22
  }
})));
Empty.displayName = 'Empty';