"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EndgameSecurityEventDetails = void 0;
var _eui = require("@elastic/eui");
var _fp = require("lodash/fp");
var _react = _interopRequireDefault(require("react"));
var _netflow = require("../netflow");
var _endgame_security_event_details_line = require("./endgame_security_event_details_line");
var _helpers = require("../helpers");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/timelines/components/timeline/body/renderers/endgame/endgame_security_event_details.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const EndgameSecurityEventDetails = exports.EndgameSecurityEventDetails = /*#__PURE__*/_react.default.memo(({
  data,
  contextId,
  timelineId
}) => {
  const endgameLogonType = (0, _fp.get)('endgame.logon_type[0]', data);
  const endgameSubjectDomainName = (0, _fp.get)('endgame.subject_domain_name[0]', data);
  const endgameSubjectLogonId = (0, _fp.get)('endgame.subject_logon_id[0]', data);
  const endgameSubjectUserName = (0, _fp.get)('endgame.subject_user_name[0]', data);
  const endgameTargetLogonId = (0, _fp.get)('endgame.target_logon_id[0]', data);
  const endgameTargetDomainName = (0, _fp.get)('endgame.target_domain_name[0]', data);
  const endgameTargetUserName = (0, _fp.get)('endgame.target_user_name[0]', data);
  const eventAction = (0, _fp.get)('event.action[0]', data);
  const eventCode = (0, _fp.get)('event.code[0]', data);
  const eventOutcome = (0, _fp.get)('event.outcome[0]', data);
  const hostName = (0, _fp.get)('host.name[0]', data);
  const id = data._id;
  const processExecutable = (0, _fp.get)('process.executable[0]', data);
  const processName = (0, _fp.get)('process.name[0]', data);
  const processPid = (0, _fp.get)('process.pid[0]', data);
  const userDomain = (0, _fp.get)('user.domain[0]', data);
  const userName = (0, _fp.get)('user.name[0]', data);
  const winlogEventId = (0, _fp.get)('winlog.event_id[0]', data);
  return /*#__PURE__*/_react.default.createElement(_helpers.Details, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_endgame_security_event_details_line.EndgameSecurityEventDetailsLine, {
    scopeId: timelineId,
    contextId: contextId,
    endgameLogonType: endgameLogonType,
    endgameSubjectDomainName: endgameSubjectDomainName,
    endgameSubjectLogonId: endgameSubjectLogonId,
    endgameSubjectUserName: endgameSubjectUserName,
    endgameTargetDomainName: endgameTargetDomainName,
    endgameTargetLogonId: endgameTargetLogonId,
    endgameTargetUserName: endgameTargetUserName,
    eventAction: eventAction,
    eventCode: eventCode,
    eventOutcome: eventOutcome,
    hostName: hostName,
    id: id,
    processExecutable: processExecutable,
    processName: processName,
    processPid: processPid,
    userDomain: userDomain,
    userName: userName,
    winlogEventId: winlogEventId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_netflow.NetflowRenderer, {
    data: data,
    timelineId: timelineId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 7
    }
  }));
});
EndgameSecurityEventDetails.displayName = 'EndgameSecurityEventDetails';