"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CellActions = void 0;
var _react = _interopRequireDefault(require("react"));
var _add_to_timeline = require("../../../timeline/components/add_to_timeline");
var _filter_in = require("../../../query_bar/components/filter_in");
var _filter_out = require("../../../query_bar/components/filter_out");
var _field_value = require("../../utils/field_value");
var _test_ids = require("./test_ids");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/threat_intelligence/modules/indicators/components/table/cell_actions.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
/**
 * Component used on an EuiDataGrid component (in our case for our IndicatorsTable component),
 * added to the cellActions property of an EuiDataGridColumn.
 * It displays the FilterIn, FilterOut and AddToTimeline icons in the popover
 * when the user hovers above a cell.
 */
const CellActions = ({
  rowIndex,
  columnId,
  Component,
  indicators,
  pagination
}) => {
  const indicator = indicators[rowIndex % pagination.pageSize];
  const {
    key,
    value
  } = (0, _field_value.getIndicatorFieldAndValue)(indicator, columnId);
  if (!(0, _field_value.fieldAndValueValid)(key, value)) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_filter_in.FilterInCellAction, {
    data: indicator,
    field: key,
    Component: Component,
    "data-test-subj": _test_ids.FILTER_IN_BUTTON_TEST_ID,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_filter_out.FilterOutCellAction, {
    data: indicator,
    field: key,
    Component: Component,
    "data-test-subj": _test_ids.FILTER_OUT_BUTTON_TEST_ID,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_add_to_timeline.AddToTimelineCellAction, {
    data: indicator,
    field: key,
    Component: Component,
    "data-test-subj": _test_ids.TIMELINE_BUTTON_TEST_ID,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 7
    }
  }));
};
exports.CellActions = CellActions;