"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RiskScoreInfoTooltip = exports.RiskScoreDocTooltip = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var i18n = _interopRequireWildcard(require("./translations"));
var _entity_analytics_learn_more_link = require("../../entity_analytics/components/entity_analytics_learn_more_link");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/overview/components/common.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const RiskScoreInfoTooltip = ({
  toolTipContent,
  toolTipTitle,
  width = 270,
  anchorPosition = 'leftCenter'
}) => {
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const onClick = (0, _react.useCallback)(() => {
    setIsPopoverOpen(!isPopoverOpen);
  }, [isPopoverOpen, setIsPopoverOpen]);
  const closePopover = (0, _react.useCallback)(() => {
    setIsPopoverOpen(false);
  }, [setIsPopoverOpen]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    isOpen: isPopoverOpen,
    closePopover: closePopover,
    anchorPosition: anchorPosition,
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      color: "text",
      size: "xs",
      iconSize: "m",
      iconType: "info",
      "aria-label": i18n.INFORMATION_ARIA_LABEL,
      onClick: onClick,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 35,
        columnNumber: 9
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 30,
      columnNumber: 5
    }
  }, toolTipTitle && /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 45,
      columnNumber: 24
    }
  }, toolTipTitle), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    style: {
      width: `${width}px`
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 46,
      columnNumber: 7
    }
  }, toolTipContent));
};
exports.RiskScoreInfoTooltip = RiskScoreInfoTooltip;
const RiskScoreDocTooltip = ({
  anchorPosition
}) => /*#__PURE__*/_react.default.createElement(RiskScoreInfoTooltip, {
  anchorPosition: anchorPosition,
  toolTipContent: /*#__PURE__*/_react.default.createElement(_entity_analytics_learn_more_link.EntityAnalyticsLearnMoreLink, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 21
    }
  }),
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 58,
    columnNumber: 3
  }
});
exports.RiskScoreDocTooltip = RiskScoreDocTooltip;