"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getCellRendererForGivenRecord = void 0;
var _react = _interopRequireWildcard(require("react"));
var _default_cell_renderer = require("../../timelines/components/timeline/cell_rendering/default_cell_renderer");
var _constants = require("../constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/one_discover/cell_renderers/cell_renderers.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 *
 * This controls the list of fields that are allowed custom security solution rendering
 * in Discover's contextual View
 *
 */
const ALLOWED_DISCOVER_RENDERED_FIELDS = ['kibana.alert.workflow_status'];
const getCellRendererForGivenRecord = fieldName => {
  if (!ALLOWED_DISCOVER_RENDERED_FIELDS.includes(fieldName)) return undefined;
  return function UnifiedFieldRenderBySecuritySolution(props) {
    // convert discover data format to timeline data format
    const data = (0, _react.useMemo)(() => Object.keys(props.row.flattened).map(field => ({
      field,
      value: Array.isArray(props.row.flattened[field]) ? props.row.flattened[field] : [props.row.flattened[field]]
    })), [props.row.flattened]);
    const header = (0, _react.useMemo)(() => {
      var _props$dataView$getFi;
      return {
        id: props.columnId,
        columnHeaderType: 'not-filtered',
        type: (_props$dataView$getFi = props.dataView.getFieldByName(props.columnId)) === null || _props$dataView$getFi === void 0 ? void 0 : _props$dataView$getFi.type
      };
    }, [props.columnId, props.dataView]);
    return /*#__PURE__*/_react.default.createElement(_default_cell_renderer.DefaultCellRenderer, {
      data: data,
      ecsData: undefined,
      eventId: props.row.id,
      header: header,
      isDetails: props.isDetails,
      isTimeline: false,
      linkValues: undefined,
      rowRenderers: undefined,
      scopeId: _constants.ONE_DISCOVER_SCOPE_ID,
      asPlainText: false,
      context: undefined,
      isExpandable: props.isExpandable,
      rowIndex: props.rowIndex,
      colIndex: props.colIndex,
      setCellProps: props.setCellProps,
      isExpanded: props.isExpanded,
      columnId: props.columnId,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 55,
        columnNumber: 7
      }
    });
  };
};
exports.getCellRendererForGivenRecord = getCellRendererForGivenRecord;