"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.StartDashboardMigrationCard = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _wrapper = require("../../../../../../../siem_migrations/dashboards/components/data_input_flyout/wrapper");
var _upload_panel = require("../../../../../../../siem_migrations/dashboards/components/status_panels/upload_panel");
var _missing_privileges = require("../../../../../../../common/components/missing_privileges");
var _use_upselling = require("../../../../../../../common/hooks/use_upselling");
var _panel_text = require("../../../../../../../common/components/panel_text");
var _centered_loading_spinner = require("../../../../../../../common/components/centered_loading_spinner");
var _constants = require("../../../../../../constants");
var _card_content_panel = require("../../../common/card_content_panel");
var _start_migration_card = require("../common/start_migration_card.styles");
var _translations = require("../common/translations");
var _dashboard_migrations_panels = require("./dashboard_migrations_panels");
var _use_latest_stats = require("../../../../../../../siem_migrations/dashboards/service/hooks/use_latest_stats");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/onboarding/components/onboarding_body/cards/siem_migrations/start_migration/dashboards/start_migration_card.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const StartDashboardMigrationBody = /*#__PURE__*/_react.default.memo(({
  setComplete,
  isCardComplete,
  setExpandedCardId,
  checkComplete
}) => {
  const styles = (0, _start_migration_card.useStyles)();
  const {
    data: migrationsStats,
    isLoading
  } = (0, _use_latest_stats.useLatestStats)();
  const isConnectorsCardComplete = (0, _react.useMemo)(() => isCardComplete(_constants.OnboardingCardId.siemMigrationsAiConnectors), [isCardComplete]);
  const expandConnectorsCard = (0, _react.useCallback)(() => {
    setExpandedCardId(_constants.OnboardingCardId.siemMigrationsAiConnectors);
  }, [setExpandedCardId]);
  const onFlyoutClosed = (0, _react.useCallback)(() => {
    checkComplete();
  }, [checkComplete]);
  return /*#__PURE__*/_react.default.createElement(_wrapper.DashboardMigrationDataInputWrapper, {
    onFlyoutClosed: onFlyoutClosed,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 47,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_card_content_panel.OnboardingCardContentPanel, {
    "data-test-subj": "startDashboardMigrationsCardBody",
    className: styles,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 9
    }
  }, isLoading ? /*#__PURE__*/_react.default.createElement(_centered_loading_spinner.CenteredLoadingSpinner, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 13
    }
  }) : /*#__PURE__*/_react.default.createElement(_dashboard_migrations_panels.DashboardMigrationsPanels, {
    migrationsStats: migrationsStats,
    isConnectorsCardComplete: isConnectorsCardComplete,
    expandConnectorsCard: expandConnectorsCard,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_panel_text.PanelText, {
    size: "xs",
    subdued: true,
    cursive: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 13
    }
  }, _translations.START_MIGRATION_CARD_FOOTER_NOTE))));
});
StartDashboardMigrationBody.displayName = 'StartDashboardMigrationsBody';
const StartDashboardMigrationCard = exports.StartDashboardMigrationCard = /*#__PURE__*/_react.default.memo(({
  checkCompleteMetadata,
  ...props
}) => {
  const UpsellSectionComp = (0, _use_upselling.useUpsellingComponent)('siem_migrations_start');
  if (!checkCompleteMetadata) {
    return /*#__PURE__*/_react.default.createElement(_centered_loading_spinner.CenteredLoadingSpinner, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 76,
        columnNumber: 14
      }
    });
  }
  if (UpsellSectionComp) {
    return /*#__PURE__*/_react.default.createElement(_card_content_panel.OnboardingCardContentPanel, {
      paddingSize: "none",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 81,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "column",
      gutterSize: "l",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 82,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 83,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(UpsellSectionComp, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 84,
        columnNumber: 15
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 86,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_upload_panel.UploadDashboardsSectionPanel, {
      isUploadMore: false,
      isDisabled: true,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 87,
        columnNumber: 15
      }
    }))));
  }
  const {
    missingCapabilities
  } = checkCompleteMetadata;
  if (missingCapabilities.length > 0) {
    return /*#__PURE__*/_react.default.createElement(_card_content_panel.OnboardingCardContentPanel, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 97,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_missing_privileges.BasicMissingPrivilegesCallOut, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 98,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_missing_privileges.MissingPrivilegesDescription, {
      privileges: missingCapabilities,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 99,
        columnNumber: 13
      }
    })));
  }
  return /*#__PURE__*/_react.default.createElement(StartDashboardMigrationBody, (0, _extends2.default)({}, props, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 12
    }
  }));
});
StartDashboardMigrationCard.displayName = 'StartDashboardMigrationCard';

// eslint-disable-next-line import/no-default-export
var _default = exports.default = StartDashboardMigrationCard;