"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OpenTimelineButtonIcon = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _helpers = require("../../timelines/components/open_timeline/helpers");
var _test_ids = require("./test_ids");
var _user_privileges = require("../../common/components/user_privileges");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/notes/components/open_timeline_button.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const OPEN_TIMELINE = _i18n.i18n.translate('xpack.securitySolution.notes.management.openTimelineButton', {
  defaultMessage: 'Open saved timeline'
});
/**
 * Renders a button to open the timeline associated with a note
 */
const OpenTimelineButtonIcon = exports.OpenTimelineButtonIcon = /*#__PURE__*/(0, _react.memo)(({
  note,
  index
}) => {
  const {
    timelinePrivileges: {
      read: canReadTimelines
    }
  } = (0, _user_privileges.useUserPrivileges)();
  const queryTimelineById = (0, _helpers.useQueryTimelineById)();
  const openTimeline = (0, _react.useCallback)(({
    timelineId
  }) => queryTimelineById({
    duplicate: false,
    onOpenTimeline: undefined,
    timelineId,
    timelineType: undefined
  }), [queryTimelineById]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "data-test-subj": `${_test_ids.OPEN_TIMELINE_BUTTON_TEST_ID}-${index}`,
    title: OPEN_TIMELINE,
    "aria-label": OPEN_TIMELINE,
    color: "text",
    iconType: "timelineWithArrow",
    onClick: () => openTimeline(note),
    disabled: !canReadTimelines,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 5
    }
  });
});
OpenTimelineButtonIcon.displayName = 'OpenTimelineButtonIcon';