"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DeviceControlProtectionLevel = void 0;
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _use_test_id_generator = require("../../../../../hooks/use_test_id_generator");
var _setting_card = require("./setting_card");
var _types = require("../../../../../../../common/endpoint/types");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/management/pages/policy/view/policy_settings_form/components/device_control_protection_level.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ALLOW_ALL_LABEL = _i18n.i18n.translate('xpack.securitySolution.endpoint.policy.details.deviceControl.allowReadWrite', {
  defaultMessage: 'Allow read, write and execute'
});
const BLOCK_LABEL = _i18n.i18n.translate('xpack.securitySolution.endpoint.policy.details.deviceControl.blockAll', {
  defaultMessage: 'Block all'
});
const READ_ONLY_LABEL = _i18n.i18n.translate('xpack.securitySolution.endpoint.policy.details.deviceControl.readOnly', {
  defaultMessage: 'Read only'
});
const BLOCK_EXECUTE_LABEL = _i18n.i18n.translate('xpack.securitySolution.endpoint.policy.details.deviceControl.executeOnly', {
  defaultMessage: 'Read and write'
});
const DeviceControlProtectionLevel = exports.DeviceControlProtectionLevel = /*#__PURE__*/(0, _react.memo)(({
  policy,
  osList,
  mode,
  onChange,
  'data-test-subj': dataTestSubj
}) => {
  const isEditMode = mode === 'edit';
  const getTestId = (0, _use_test_id_generator.useTestIdGenerator)(dataTestSubj);
  const radios = (0, _react.useMemo)(() => {
    return [{
      id: _types.DeviceControlAccessLevel.audit,
      label: ALLOW_ALL_LABEL
    }, {
      id: _types.DeviceControlAccessLevel.no_execute,
      label: BLOCK_EXECUTE_LABEL
    }, {
      id: _types.DeviceControlAccessLevel.read_only,
      label: READ_ONLY_LABEL
    }, {
      id: _types.DeviceControlAccessLevel.deny_all,
      label: BLOCK_LABEL
    }];
  }, []);
  const getCurrentAccessLevel = (0, _react.useMemo)(() => {
    var _policy$windows$devic, _policy$mac$device_co;
    if ((_policy$windows$devic = policy.windows.device_control) !== null && _policy$windows$devic !== void 0 && _policy$windows$devic.usb_storage) {
      return policy.windows.device_control.usb_storage;
    }
    if ((_policy$mac$device_co = policy.mac.device_control) !== null && _policy$mac$device_co !== void 0 && _policy$mac$device_co.usb_storage) {
      return policy.mac.device_control.usb_storage;
    }
    return _types.DeviceControlAccessLevel.audit;
  }, [policy]);
  const currentAccessLevelLabel = (0, _react.useMemo)(() => {
    const radio = radios.find(item => item.id === getCurrentAccessLevel);
    if (radio) {
      return radio.label;
    }
    return BLOCK_LABEL;
  }, [getCurrentAccessLevel, radios]);
  const isDeviceControlEnabled = (0, _react.useMemo)(() => {
    // Check if device control is enabled on any OS
    return osList.some(os => {
      if (os === 'windows' || os === 'mac') {
        var _policy$os$device_con;
        return (_policy$os$device_con = policy[os].device_control) === null || _policy$os$device_con === void 0 ? void 0 : _policy$os$device_con.enabled;
      }
      return false;
    });
  }, [policy, osList]);
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": getTestId(),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 118,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_setting_card.SettingCardHeader, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 119,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.endpoint.policyDetailsConfig.deviceControl.usbStorageLevel",
    defaultMessage: "USB storage access level",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 120,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 125,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xl",
    wrap: true,
    responsive: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 126,
      columnNumber: 9
    }
  }, isEditMode ? radios.map(({
    label,
    id
  }) => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      key: id,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 130,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(DeviceControlAccessRadio, {
      policy: policy,
      onChange: onChange,
      mode: mode,
      accessLevel: id,
      osList: osList,
      label: label,
      isEnabled: isDeviceControlEnabled,
      "data-test-subj": getTestId(`${id}Radio`),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 131,
        columnNumber: 19
      }
    }));
  }) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, currentAccessLevelLabel)));
});
DeviceControlProtectionLevel.displayName = 'DeviceControlProtectionLevel';
const DeviceControlAccessRadio = /*#__PURE__*/_react.default.memo(({
  accessLevel,
  osList,
  label,
  isEnabled,
  onChange,
  policy,
  mode,
  'data-test-subj': dataTestSubj
}) => {
  const getCurrentAccessLevel = () => {
    var _policy$windows$devic2, _policy$mac$device_co2;
    // Check Windows first, then Mac for device_control configuration
    if ((_policy$windows$devic2 = policy.windows.device_control) !== null && _policy$windows$devic2 !== void 0 && _policy$windows$devic2.usb_storage) {
      return policy.windows.device_control.usb_storage;
    }
    if ((_policy$mac$device_co2 = policy.mac.device_control) !== null && _policy$mac$device_co2 !== void 0 && _policy$mac$device_co2.usb_storage) {
      return policy.mac.device_control.usb_storage;
    }
    return _types.DeviceControlAccessLevel.audit;
  };
  const selected = getCurrentAccessLevel();
  const showEditableFormFields = mode === 'edit';
  const radioId = (0, _react.useMemo)(() => {
    return `${osList.join('-')}-device_control-${accessLevel}`;
  }, [osList, accessLevel]);
  const handleRadioChange = (0, _react.useCallback)(() => {
    const newPayload = (0, _lodash.cloneDeep)(policy);
    if (!newPayload.windows.device_control) {
      newPayload.windows.device_control = {
        enabled: true,
        usb_storage: accessLevel
      };
    } else {
      newPayload.windows.device_control.usb_storage = accessLevel;
    }
    if (!newPayload.mac.device_control) {
      newPayload.mac.device_control = {
        enabled: true,
        usb_storage: accessLevel
      };
    } else {
      newPayload.mac.device_control.usb_storage = accessLevel;
    }

    // Manage notifications based on access level
    if (accessLevel === _types.DeviceControlAccessLevel.deny_all) {
      if (newPayload.windows.popup.device_control) {
        newPayload.windows.popup.device_control.enabled = true;
      }
      if (newPayload.mac.popup.device_control) {
        newPayload.mac.popup.device_control.enabled = true;
      }
    } else {
      if (newPayload.windows.popup.device_control) {
        newPayload.windows.popup.device_control.enabled = false;
      }
      if (newPayload.mac.popup.device_control) {
        newPayload.mac.popup.device_control.enabled = false;
      }
    }
    onChange({
      isValid: true,
      updatedPolicy: newPayload
    });
  }, [accessLevel, onChange, policy]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiRadio, {
    name: radioId,
    label: label,
    id: radioId,
    checked: selected === accessLevel,
    onChange: handleRadioChange,
    disabled: !showEditableFormFields || !isEnabled,
    "data-test-subj": dataTestSubj,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 232,
      columnNumber: 7
    }
  });
});
DeviceControlAccessRadio.displayName = 'DeviceControlAccessRadio';