"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RansomwareProtectionCard = exports.LOCKED_CARD_RAMSOMWARE_TITLE = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _securitysolutionUtils = require("@kbn/securitysolution-utils");
var _use_test_id_generator = require("../../../../../../hooks/use_test_id_generator");
var _protection_setting_card_switch = require("../protection_setting_card_switch");
var _notify_user_option = require("../notify_user_option");
var _detect_prevent_protection_level = require("../detect_prevent_protection_level");
var _setting_card = require("../setting_card");
var _types = require("../../../../../../../../common/endpoint/types");
var _use_license = require("../../../../../../../common/hooks/use_license");
var _setting_locked_card = require("../setting_locked_card");
var _use_get_protections_unavailable_component = require("../../hooks/use_get_protections_unavailable_component");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/management/pages/policy/view/policy_settings_form/components/cards/ransomware_protection_card.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const RANSOMEWARE_OS_VALUES = [_types.PolicyOperatingSystem.windows];
const LOCKED_CARD_RAMSOMWARE_TITLE = exports.LOCKED_CARD_RAMSOMWARE_TITLE = _i18n.i18n.translate('xpack.securitySolution.endpoint.policy.details.ransomware', {
  defaultMessage: 'Ransomware'
});
const RansomwareProtectionCard = exports.RansomwareProtectionCard = /*#__PURE__*/_react.default.memo(({
  policy,
  onChange,
  mode,
  'data-test-subj': dataTestSubj
}) => {
  const isPlatinumPlus = (0, _use_license.useLicense)().isPlatinumPlus();
  const isProtectionsAllowed = !(0, _use_get_protections_unavailable_component.useGetProtectionsUnavailableComponent)();
  const getTestId = (0, _use_test_id_generator.useTestIdGenerator)(dataTestSubj);
  const protection = 'ransomware';
  const selected = (policy && policy.windows[protection].mode) !== _types.ProtectionModes.off;
  const protectionLabel = _i18n.i18n.translate('xpack.securitySolution.endpoint.policy.protections.ransomware', {
    defaultMessage: 'Ransomware protections'
  });
  if (!isProtectionsAllowed) {
    return null;
  }
  if (!isPlatinumPlus) {
    return /*#__PURE__*/_react.default.createElement(_setting_locked_card.SettingLockedCard, {
      title: LOCKED_CARD_RAMSOMWARE_TITLE,
      "data-test-subj": getTestId('locked'),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 61,
        columnNumber: 9
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_setting_card.SettingCard, {
    type: _i18n.i18n.translate('xpack.securitySolution.endpoint.policy.details.ransomware', {
      defaultMessage: 'Ransomware'
    }),
    supportedOss: [_securitysolutionUtils.OperatingSystem.WINDOWS],
    dataTestSubj: getTestId(),
    selected: selected,
    mode: mode,
    rightCorner: /*#__PURE__*/_react.default.createElement(_protection_setting_card_switch.ProtectionSettingCardSwitch, {
      selected: selected,
      policy: policy,
      onChange: onChange,
      mode: mode,
      protection: protection,
      protectionLabel: protectionLabel,
      osList: RANSOMEWARE_OS_VALUES,
      "data-test-subj": getTestId('enableDisableSwitch'),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 78,
        columnNumber: 11
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_detect_prevent_protection_level.DetectPreventProtectionLevel, {
    protection: protection,
    osList: RANSOMEWARE_OS_VALUES,
    onChange: onChange,
    policy: policy,
    mode: mode,
    "data-test-subj": getTestId('protectionLevel'),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 90,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_notify_user_option.NotifyUserOption, {
    policy: policy,
    onChange: onChange,
    mode: mode,
    protection: protection,
    osList: RANSOMEWARE_OS_VALUES,
    "data-test-subj": getTestId('notifyUser'),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 9
    }
  }));
});
RansomwareProtectionCard.displayName = 'RansomwareProtectionCard';