"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HostIsolationExceptionsList = void 0;
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _kibana = require("../../../../common/lib/kibana");
var _artifact_list_page = require("../../../components/artifact_list_page");
var _host_isolation_exceptions_api_client = require("../host_isolation_exceptions_api_client");
var _constants = require("../constants");
var _form = require("./components/form");
var _user_privileges = require("../../../../common/components/user_privileges");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/management/pages/host_isolation_exceptions/view/host_isolation_exceptions_list.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const HOST_ISOLATION_EXCEPTIONS_LABELS = Object.freeze({
  pageTitle: _i18n.i18n.translate('xpack.securitySolution.hostIsolationExceptions.pageTitle', {
    defaultMessage: 'Host isolation exceptions'
  }),
  pageAboutInfo: _i18n.i18n.translate('xpack.securitySolution.hostIsolationExceptions.pageAboutInfo', {
    defaultMessage: 'Add a host isolation exception to allow isolated hosts to communicate with specific IPs.'
  }),
  pageAddButtonTitle: _i18n.i18n.translate('xpack.securitySolution.hostIsolationExceptions.pageAddButtonTitle', {
    defaultMessage: 'Add host isolation exception'
  }),
  getShowingCountLabel: total => _i18n.i18n.translate('xpack.securitySolution.hostIsolationExceptions.showingTotal', {
    defaultMessage: 'Showing {total} {total, plural, one {host isolation exception} other {host isolation exceptions}}',
    values: {
      total
    }
  }),
  cardActionEditLabel: _i18n.i18n.translate('xpack.securitySolution.hostIsolationExceptions.cardActionEditLabel', {
    defaultMessage: 'Edit exception'
  }),
  cardActionDeleteLabel: _i18n.i18n.translate('xpack.securitySolution.hostIsolationExceptions.cardActionDeleteLabel', {
    defaultMessage: 'Delete exception'
  }),
  flyoutCreateTitle: _i18n.i18n.translate('xpack.securitySolution.hostIsolationExceptions.flyoutCreateTitle', {
    defaultMessage: 'Add host isolation exception'
  }),
  flyoutEditTitle: _i18n.i18n.translate('xpack.securitySolution.hostIsolationExceptions.flyoutEditTitle', {
    defaultMessage: 'Edit host isolation exception'
  }),
  flyoutCreateSubmitButtonLabel: _i18n.i18n.translate('xpack.securitySolution.hostIsolationExceptions.flyoutCreateSubmitButtonLabel', {
    defaultMessage: 'Add host isolation exception'
  }),
  flyoutCreateSubmitSuccess: ({
    name
  }) => _i18n.i18n.translate('xpack.securitySolution.hostIsolationExceptions.flyoutCreateSubmitSuccess', {
    defaultMessage: '"{name}" has been added to your host isolation exception list.',
    values: {
      name
    }
  }),
  flyoutEditSubmitSuccess: ({
    name
  }) => _i18n.i18n.translate('xpack.securitySolution.hostIsolationExceptions.flyoutEditSubmitSuccess', {
    defaultMessage: '"{name}" has been updated.',
    values: {
      name
    }
  }),
  flyoutDowngradedLicenseDocsInfo: () => {
    // Host Isolation Exceptions does not need to show a downgrade license message because
    // this feature is only available for license levels that also includes per-policy functionality.
    return null;
  },
  deleteModalTitle: () => _i18n.i18n.translate('xpack.securitySolution.hostIsolationExceptions.deleteModtalTitle', {
    defaultMessage: 'Delete host isolation exception'
  }),
  deleteActionSuccess: itemName => _i18n.i18n.translate('xpack.securitySolution.hostIsolationExceptions.deleteSuccess', {
    defaultMessage: '"{itemName}" has been removed from host isolation exception list.',
    values: {
      itemName
    }
  }),
  emptyStateTitleNoEntries: _i18n.i18n.translate('xpack.securitySolution.hostIsolationExceptions.emptyStateTitleNoEntries', {
    defaultMessage: 'There are no host isolation exceptions to display.'
  }),
  emptyStateTitle: _i18n.i18n.translate('xpack.securitySolution.hostIsolationExceptions.emptyStateTitle', {
    defaultMessage: 'Add your first host isolation exception'
  }),
  emptyStateInfo: _i18n.i18n.translate('xpack.securitySolution.hostIsolationExceptions.emptyStateInfo', {
    defaultMessage: 'Add a host isolation exception to allow isolated hosts to communicate with specific IPs.'
  }),
  emptyStatePrimaryButtonLabel: _i18n.i18n.translate('xpack.securitySolution.hostIsolationExceptions.emptyStatePrimaryButtonLabel', {
    defaultMessage: 'Add host isolation exception'
  }),
  searchPlaceholderInfo: _i18n.i18n.translate('xpack.securitySolution.hostIsolationExceptions.searchPlaceholderInfo', {
    defaultMessage: 'Search on the fields below: name, description, IP'
  })
});
const HostIsolationExceptionsList = exports.HostIsolationExceptionsList = /*#__PURE__*/(0, _react.memo)(() => {
  const http = (0, _kibana.useHttp)();
  const apiClient = _host_isolation_exceptions_api_client.HostIsolationExceptionsApiClient.getInstance(http);
  const {
    canWriteHostIsolationExceptions,
    canDeleteHostIsolationExceptions
  } = (0, _user_privileges.useUserPrivileges)().endpointPrivileges;
  return /*#__PURE__*/_react.default.createElement(_artifact_list_page.ArtifactListPage, {
    apiClient: apiClient,
    ArtifactFormComponent: _form.HostIsolationExceptionsForm,
    labels: HOST_ISOLATION_EXCEPTIONS_LABELS,
    "data-test-subj": "hostIsolationExceptionsListPage",
    searchableFields: _constants.SEARCHABLE_FIELDS,
    allowCardCreateAction: canWriteHostIsolationExceptions,
    allowCardEditAction: canWriteHostIsolationExceptions,
    allowCardDeleteAction: canDeleteHostIsolationExceptions,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 125,
      columnNumber: 5
    }
  });
});
HostIsolationExceptionsList.displayName = 'HostIsolationExceptionsList';