"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EndpointDetailsTabsTypes = exports.EndpointDetailsFlyoutTabs = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _flyout_header = require("./flyout_header");
var _use_navigate_by_router_event_handler = require("../../../../../../common/hooks/endpoint/use_navigate_by_router_event_handler");
var _kibana = require("../../../../../../common/lib/kibana");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/management/pages/endpoint_hosts/view/details/components/endpoint_details_tabs.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
let EndpointDetailsTabsTypes = exports.EndpointDetailsTabsTypes = /*#__PURE__*/function (EndpointDetailsTabsTypes) {
  EndpointDetailsTabsTypes["overview"] = "details";
  EndpointDetailsTabsTypes["activityLog"] = "activity_log";
  return EndpointDetailsTabsTypes;
}({});
const EndpointDetailsTab = /*#__PURE__*/(0, _react.memo)(({
  tab,
  isSelected
}) => {
  const {
    getAppUrl
  } = (0, _kibana.useAppUrl)();
  const onClick = (0, _use_navigate_by_router_event_handler.useNavigateByRouterEventHandler)(tab.route);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
    href: getAppUrl({
      path: tab.route
    }),
    onClick: onClick,
    isSelected: isSelected,
    key: tab.id,
    "data-test-subj": `endpoint-details-flyout-tab-${tab.id}`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 33,
      columnNumber: 7
    }
  }, tab.name);
});
EndpointDetailsTab.displayName = 'EndpointDetailsTab';
const EndpointDetailsFlyoutTabs = exports.EndpointDetailsFlyoutTabs = /*#__PURE__*/(0, _react.memo)(({
  hostname,
  isHostInfoLoading,
  show,
  tabs
}) => {
  const selectedTab = (0, _react.useMemo)(() => tabs.find(tab => tab.id === show), [tabs, show]);
  const renderTabs = tabs.map(tab => /*#__PURE__*/_react.default.createElement(EndpointDetailsTab, {
    key: tab.id,
    tab: tab,
    isSelected: tab.id === (selectedTab === null || selectedTab === void 0 ? void 0 : selectedTab.id),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 7
    }
  }));
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_flyout_header.EndpointDetailsFlyoutHeader, {
    hostname: hostname,
    isHostInfoLoading: isHostInfoLoading,
    hasBorder: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTabs, {
    bottomBorder: false,
    css: {
      marginBottom: '-25px'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 11
    }
  }, renderTabs)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
    "data-test-subj": `endpoint${(selectedTab === null || selectedTab === void 0 ? void 0 : selectedTab.id) === 'details' ? 'Details' : 'ActivityLog'}FlyoutBody`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 9
    }
  }, selectedTab === null || selectedTab === void 0 ? void 0 : selectedTab.content));
});
EndpointDetailsFlyoutTabs.displayName = 'EndpointDetailsFlyoutTabs';