"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EnteredInput = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireDefault(require("react"));
var _argument_selector_wrapper = require("../components/argument_selector_wrapper");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/management/components/console/components/command_input/lib/entered_input.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const ARGUMENT_NAME_VALUE_SEPARATORS = ['', ' ', '='];
const createInputCharacter = (overrides = {}) => {
  return {
    value: '',
    renderValue: null,
    isArgSelector: false,
    argName: '',
    argIndex: 0,
    argState: undefined,
    ...overrides
  };
};
const getInputCharacters = input => {
  return input.split('').map(char => {
    return createInputCharacter({
      value: char,
      renderValue: char
    });
  });
};
const toValueDisplayElement = (prefix, item, index) => {
  var _item$value;
  return /*#__PURE__*/_react.default.createElement("span", {
    className: "chr",
    key: `${prefix}.${index}.${(_item$value = item.value) !== null && _item$value !== void 0 ? _item$value : '$'}`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 5
    }
  }, item.renderValue);
};
const toInputCharacterDisplayString = (includeArgSelectorValues, item) => {
  let response = item.value;
  if (includeArgSelectorValues && item.isArgSelector) {
    var _item$argState$valueT, _item$argState;
    response += `="${(_item$argState$valueT = (_item$argState = item.argState) === null || _item$argState === void 0 ? void 0 : _item$argState.valueText) !== null && _item$argState$valueT !== void 0 ? _item$argState$valueT : ''}"`;
  }
  return response;
};

/**
 * Class that manages the command entered and how that is displayed to the left and right of the cursor
 */
class EnteredInput {
  constructor(leftOfCursorText, rightOfCursorText, parsedInput, enteredCommand) {
    (0, _defineProperty2.default)(this, "leftOfCursorContent", void 0);
    (0, _defineProperty2.default)(this, "rightOfCursorContent", void 0);
    (0, _defineProperty2.default)(this, "canHaveArgValueSelectors", void 0);
    (0, _defineProperty2.default)(this, "argState", void 0);
    this.leftOfCursorContent = getInputCharacters(leftOfCursorText);
    this.rightOfCursorContent = getInputCharacters(rightOfCursorText);
    this.canHaveArgValueSelectors = Boolean(enteredCommand === null || enteredCommand === void 0 ? void 0 : enteredCommand.argsWithValueSelectors);

    // Determine if any argument value selector should be inserted
    if (parsedInput.hasArgs && enteredCommand && enteredCommand.argsWithValueSelectors) {
      this.argState = enteredCommand.argState;
      const inputPieces = [{
        input: leftOfCursorText,
        items: this.leftOfCursorContent,
        side: 'left'
      }, {
        input: rightOfCursorText,
        items: this.rightOfCursorContent,
        side: 'right'
      }];
      for (const [argName, argDef] of Object.entries(enteredCommand.argsWithValueSelectors)) {
        // If the argument has been used, then replace it with the Arguments Selector
        if (parsedInput.hasArg(argName)) {
          let argIndex = 0;

          // Loop through the input pieces (left and right side of cursor) looking for the Argument name
          for (const {
            input,
            items,
            side
          } of inputPieces) {
            const argNameMatch = `--${argName}`;
            let pos = input.indexOf(argNameMatch);
            while (pos > -1) {
              const argChrLength = argNameMatch.length;
              const startSearchIndexForNextArg = pos + argChrLength;
              const charAfterArgName = input.charAt(startSearchIndexForNextArg);
              const argNameMatchesAsWholeWord = side === 'left' && charAfterArgName === '' &&
              // if cursor is at the end of the argument name on the left side of the cursor,
              // then we check to ensure that the first character of the Right side of the
              // cursor is one of the separators. Example (| === cursor): `--file|s`
              ARGUMENT_NAME_VALUE_SEPARATORS.includes(rightOfCursorText.charAt(0));

              // We need to Ensure that the argument name is not part of a longer word
              // (example: matches `--file` not `--files`)
              if (ARGUMENT_NAME_VALUE_SEPARATORS.includes(charAfterArgName) && (argNameMatchesAsWholeWord || side === 'left' && charAfterArgName !== '' || side === 'right')) {
                var _enteredCommand$argSt;
                const replaceValues = Array.from({
                  length: argChrLength
                }, createInputCharacter);
                const argState = (_enteredCommand$argSt = enteredCommand.argState[argName]) === null || _enteredCommand$argSt === void 0 ? void 0 : _enteredCommand$argSt.at(argIndex);
                replaceValues[0] = createInputCharacter({
                  value: argNameMatch,
                  renderValue: /*#__PURE__*/_react.default.createElement(_argument_selector_wrapper.ArgumentSelectorWrapper, {
                    argName: argName,
                    argIndex: argIndex,
                    argDefinition: argDef,
                    __self: this,
                    __source: {
                      fileName: _jsxFileName,
                      lineNumber: 144,
                      columnNumber: 21
                    }
                  }),
                  isArgSelector: true,
                  argName,
                  argIndex: argIndex++,
                  argState
                });
                items.splice(pos, argChrLength, ...replaceValues);
              }
              pos = input.indexOf(argNameMatch, startSearchIndexForNextArg);
            }
          }
        }
      }

      // Remove all empty characters (created as a result of inserting any Argument Selector components)
      this.leftOfCursorContent = this.leftOfCursorContent.filter(({
        value
      }) => value.length > 0);
      this.rightOfCursorContent = this.rightOfCursorContent.filter(({
        value
      }) => value.length > 0);
    }
  }
  replaceSelection(selection, newValue) {
    const prevFullTextEntered = this.getFullText();
    const newValueContent = newValue ? createInputCharacter({
      value: newValue
    }) : undefined;
    let start = prevFullTextEntered.indexOf(selection);
    const fullContent = [...this.leftOfCursorContent, ...this.rightOfCursorContent];

    // Adjust the `start` to account for arguments that have value selectors.
    // These arguments, are stored in the `fullContent` array as one single array item instead of
    // one per-character. The adjustment needs to be done only if the argument appears to the left
    // of the selection
    if (this.canHaveArgValueSelectors) {
      fullContent.forEach((inputCharacter, index) => {
        if (inputCharacter.isArgSelector && index < start) {
          start = start - (inputCharacter.value.length - 1);
        }
      });
    }
    const removedChars = fullContent.splice(start, selection.length);
    if (newValueContent) {
      fullContent.splice(start, 0, newValueContent);
      start++;
    }
    this.leftOfCursorContent = fullContent.splice(0, start);
    this.rightOfCursorContent = fullContent;
    this.removeArgState(removedChars);
  }
  removeArgState(argStateList) {
    if (this.argState) {
      let argStateWasAdjusted = false;
      const newArgState = {
        ...this.argState
      };
      for (const {
        argName,
        argIndex,
        isArgSelector
      } of argStateList) {
        var _newArgState$argName;
        if (isArgSelector && (_newArgState$argName = newArgState[argName]) !== null && _newArgState$argName !== void 0 && _newArgState$argName.at(argIndex)) {
          newArgState[argName] = newArgState[argName].filter((_, index) => {
            return index !== argIndex;
          });
          argStateWasAdjusted = true;
        }
      }
      if (argStateWasAdjusted) {
        this.argState = newArgState;
      }
    }
  }
  getLeftOfCursorText(includeArgSelectorValues = false) {
    return this.leftOfCursorContent.map(toInputCharacterDisplayString.bind(null, includeArgSelectorValues)).join('');
  }
  getRightOfCursorText(includeArgSelectorValues = false) {
    return this.rightOfCursorContent.map(toInputCharacterDisplayString.bind(null, includeArgSelectorValues)).join('');
  }
  getFullText(includeArgSelectorValues = false) {
    return this.getLeftOfCursorText(includeArgSelectorValues) + this.getRightOfCursorText(includeArgSelectorValues);
  }
  getLeftOfCursorRenderingContent() {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, this.leftOfCursorContent.map(toValueDisplayElement.bind(null, 'left')));
  }
  getRightOfCursorRenderingContent() {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, this.rightOfCursorContent.map(toValueDisplayElement.bind(null, 'right')));
  }
  getArgState() {
    return this.argState;
  }
  moveCursorTo(direction) {
    switch (direction) {
      case 'end':
        this.leftOfCursorContent.push(...this.rightOfCursorContent.splice(0));
        break;
      case 'home':
        this.rightOfCursorContent.unshift(...this.leftOfCursorContent.splice(0));
        break;
      case 'left':
        if (this.leftOfCursorContent.length) {
          const itemToMove = this.leftOfCursorContent.pop();
          if (itemToMove) {
            this.rightOfCursorContent.unshift(itemToMove);
          }
        }
        break;
      case 'right':
        if (this.rightOfCursorContent.length) {
          const itemToMove = this.rightOfCursorContent.shift();
          if (itemToMove) {
            this.leftOfCursorContent.push(itemToMove);
          }
        }
        break;
    }
  }
  addValue(value, replaceSelection = '') {
    if (replaceSelection.length && value.length) {
      this.replaceSelection(replaceSelection, value);
    } else if (value) {
      this.leftOfCursorContent.push(createInputCharacter({
        value
      }));
    }
  }
  deleteChar(replaceSelection = '') {
    if (replaceSelection) {
      this.replaceSelection(replaceSelection, '');
    } else {
      const removedChar = this.rightOfCursorContent.shift();
      if (removedChar !== null && removedChar !== void 0 && removedChar.isArgSelector) {
        this.removeArgState([removedChar]);
      }
    }
  }
  backspaceChar(replaceSelection = '') {
    if (replaceSelection) {
      this.replaceSelection(replaceSelection, '');
    } else {
      const removedChar = this.leftOfCursorContent.pop();
      if (removedChar !== null && removedChar !== void 0 && removedChar.isArgSelector) {
        this.removeArgState([removedChar]);
      }
    }
  }
  clear() {
    this.leftOfCursorContent = [];
    this.rightOfCursorContent = [];
    this.argState = undefined;
  }
}
exports.EnteredInput = EnteredInput;