"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PanelHeader = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _deeplinksSecurity = require("@kbn/deeplinks-security");
var _link_to = require("../../common/components/link_to");
var _links = require("../../common/components/links");
var _flyout_header = require("../shared/components/flyout_header");
var _flyout_title = require("../shared/components/flyout_title");
var _helpers = require("../../common/lib/helpers");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/flyout/network_details/header.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 *  Header component for the network details flyout
 */
const PanelHeader = exports.PanelHeader = /*#__PURE__*/(0, _react.memo)(({
  ip,
  flowTarget,
  ...flyoutHeaderProps
}) => {
  const href = (0, _react.useMemo)(() => (0, _link_to.getNetworkDetailsUrl)(encodeURIComponent((0, _helpers.encodeIpv6)(ip)), flowTarget), [flowTarget, ip]);
  return /*#__PURE__*/_react.default.createElement(_flyout_header.FlyoutHeader, (0, _extends2.default)({}, flyoutHeaderProps, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 41,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_links.SecuritySolutionLinkAnchor, {
    deepLinkId: _deeplinksSecurity.SecurityPageName.network,
    path: href,
    target: '_blank',
    external: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 42,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_flyout_title.FlyoutTitle, {
    title: ip,
    iconType: 'globe',
    isLink: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 11
    }
  })));
});
PanelHeader.displayName = 'PanelHeader';