"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HostEntityOverview = exports.HOST_PREVIEW_BANNER = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _fp = require("lodash/fp");
var _i18n = require("@kbn/i18n");
var _ui_metrics = require("@kbn/cloud-security-posture-common/utils/ui_metrics");
var _use_has_misconfigurations = require("@kbn/cloud-security-posture/src/hooks/use_has_misconfigurations");
var _use_has_vulnerabilities = require("@kbn/cloud-security-posture/src/hooks/use_has_vulnerabilities");
var _use_experimental_features = require("../../../../common/hooks/use_experimental_features");
var _use_non_closed_alerts = require("../../../../cloud_security_posture/hooks/use_non_closed_alerts");
var _search_strategy = require("../../../../../common/search_strategy");
var _constants = require("../../../../timelines/components/timeline/body/renderers/constants");
var _use_risk_score = require("../../../../entity_analytics/api/hooks/use_risk_score");
var _context = require("../../shared/context");
var _first_last_seen = require("../../../../common/components/first_last_seen/first_last_seen");
var _types = require("../../../../../common/entity_analytics/types");
var _empty_value = require("../../../../common/components/empty_value");
var _page = require("../../../../common/components/page");
var _overview_description_list = require("../../../../common/components/overview_description_list");
var _common = require("../../../../entity_analytics/components/severity/common");
var _containers = require("../../../../sourcerer/containers");
var _use_global_time = require("../../../../common/containers/use_global_time");
var _details = require("../../../../explore/hosts/containers/hosts/details");
var _utils = require("../../shared/utils");
var _cell_actions = require("../../shared/components/cell_actions");
var _translations = require("../../../../overview/components/host_overview/translations");
var _test_ids = require("./test_ids");
var _common2 = require("../../../../overview/components/common");
var _preview_link = require("../../../shared/components/preview_link");
var _misconfiguration_insight = require("../../shared/components/misconfiguration_insight");
var _vulnerabilities_insight = require("../../shared/components/vulnerabilities_insight");
var _alert_count_insight = require("../../shared/components/alert_count_insight");
var _use_navigate_to_host_details = require("../../../entity_details/host_right/hooks/use_navigate_to_host_details");
var _use_selected_patterns = require("../../../../data_view_manager/hooks/use_selected_patterns");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/flyout/document_details/right/components/host_entity_overview.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const HOST_ICON = 'storage';
const HOST_ENTITY_OVERVIEW_ID = 'host-entity-overview';
const HOST_PREVIEW_BANNER = exports.HOST_PREVIEW_BANNER = {
  title: _i18n.i18n.translate('xpack.securitySolution.flyout.right.host.hostPreviewTitle', {
    defaultMessage: 'Preview host details'
  }),
  backgroundColor: 'warning',
  textColor: 'warning'
};

/**
 * Host preview content for the entities preview in right flyout. It contains ip addresses and risk level
 */
const HostEntityOverview = ({
  hostName
}) => {
  const {
    scopeId
  } = (0, _context.useDocumentDetailsContext)();
  const {
    from,
    to
  } = (0, _use_global_time.useGlobalTime)();
  const {
    selectedPatterns: oldSelectedPatterns
  } = (0, _containers.useSourcererDataView)();
  const newDataViewPickerEnabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('newDataViewPickerEnabled');
  const experimentalSelectedPatterns = (0, _use_selected_patterns.useSelectedPatterns)();
  const selectedPatterns = newDataViewPickerEnabled ? experimentalSelectedPatterns : oldSelectedPatterns;
  const timerange = (0, _react.useMemo)(() => ({
    from,
    to
  }), [from, to]);
  const filterQuery = (0, _react.useMemo)(() => hostName ? (0, _search_strategy.buildHostNamesFilter)([hostName]) : undefined, [hostName]);
  const {
    data: hostRisk,
    isAuthorized,
    loading: isRiskScoreLoading
  } = (0, _use_risk_score.useRiskScore)({
    filterQuery,
    riskEntity: _types.EntityType.host,
    skip: hostName == null,
    timerange
  });
  const hostRiskData = hostRisk && hostRisk.length > 0 ? hostRisk[0] : undefined;
  const isRiskScoreExist = !!(hostRiskData !== null && hostRiskData !== void 0 && hostRiskData.host.risk);
  const [isHostDetailsLoading, {
    hostDetails
  }] = (0, _details.useHostDetails)({
    hostName,
    indexNames: selectedPatterns,
    startDate: from,
    endDate: to
  });
  const hostOSFamilyValue = (0, _react.useMemo)(() => (0, _utils.getField)((0, _fp.getOr)([], 'host.os.family', hostDetails)), [hostDetails]);
  const hostOSFamily = (0, _react.useMemo)(() => [{
    title: _translations.FAMILY,
    description: hostOSFamilyValue ? /*#__PURE__*/_react.default.createElement(_cell_actions.CellActions, {
      field: 'host.os.family',
      value: hostOSFamilyValue,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 147,
        columnNumber: 11
      }
    }, hostOSFamilyValue) : (0, _empty_value.getEmptyTagValue)()
  }], [hostOSFamilyValue]);
  const hostLastSeen = (0, _react.useMemo)(() => [{
    title: _translations.LAST_SEEN,
    description: /*#__PURE__*/_react.default.createElement(_first_last_seen.FirstLastSeen, {
      indexPatterns: selectedPatterns,
      field: _constants.HOST_NAME_FIELD_NAME,
      value: hostName,
      type: _first_last_seen.FirstLastSeenType.LAST_SEEN,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 163,
        columnNumber: 11
      }
    })
  }], [hostName, selectedPatterns]);
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const xsFontSize = (0, _eui.useEuiFontSize)('xs').fontSize;
  const [hostRiskLevel] = (0, _react.useMemo)(() => [{
    title: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "flexEnd",
      gutterSize: "none",
      responsive: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 182,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 183,
        columnNumber: 13
      }
    }, _translations.HOST_RISK_LEVEL), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 184,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_common2.RiskScoreDocTooltip, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 185,
        columnNumber: 15
      }
    }))),
    description: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, hostRiskData ? /*#__PURE__*/_react.default.createElement(_common.RiskScoreLevel, {
      severity: hostRiskData.host.risk.calculated_level,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 192,
        columnNumber: 15
      }
    }) : (0, _empty_value.getEmptyTagValue)())
  }], [hostRiskData]);
  const {
    hasNonClosedAlerts
  } = (0, _use_non_closed_alerts.useNonClosedAlerts)({
    field: _types.EntityIdentifierFields.hostName,
    value: hostName,
    to,
    from,
    queryId: HOST_ENTITY_OVERVIEW_ID
  });
  const {
    hasMisconfigurationFindings
  } = (0, _use_has_misconfigurations.useHasMisconfigurations)('host.name', hostName);
  const {
    hasVulnerabilitiesFindings
  } = (0, _use_has_vulnerabilities.useHasVulnerabilities)('host.name', hostName);
  const {
    openDetailsPanel
  } = (0, _use_navigate_to_host_details.useNavigateToHostDetails)({
    hostName,
    scopeId,
    isRiskScoreExist,
    hasMisconfigurationFindings,
    hasVulnerabilitiesFindings,
    hasNonClosedAlerts,
    isPreviewMode: true,
    // setting to true to always open a new host flyout
    contextID: 'HostEntityOverview'
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "m",
    responsive: false,
    "data-test-subj": _test_ids.ENTITIES_HOST_OVERVIEW_TEST_ID,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 225,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 231,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    responsive: false,
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 232,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 233,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: HOST_ICON,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 234,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 236,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_preview_link.PreviewLink, {
    field: _constants.HOST_NAME_FIELD_NAME,
    value: hostName,
    scopeId: scopeId,
    "data-test-subj": _test_ids.ENTITIES_HOST_OVERVIEW_LINK_TEST_ID,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 237,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    css: (0, _react2.css)`
                  font-size: ${xsFontSize};
                  font-weight: ${euiTheme.font.weight.bold};
                `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 243,
      columnNumber: 15
    }
  }, hostName))))), isRiskScoreLoading || isHostDetailsLoading ? /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
    "data-test-subj": _test_ids.ENTITIES_HOST_OVERVIEW_LOADING_TEST_ID,
    contentAriaLabel: _i18n.i18n.translate('xpack.securitySolution.flyout.right.insights.entities.hostLoadingAriaLabel', {
      defaultMessage: 'host overview'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 256,
      columnNumber: 9
    }
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 264,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 265,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 266,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_overview_description_list.OverviewDescriptionList, {
    dataTestSubj: _test_ids.ENTITIES_HOST_OVERVIEW_OS_FAMILY_TEST_ID,
    descriptionList: hostOSFamily,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 267,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 272,
      columnNumber: 13
    }
  }, isAuthorized ? /*#__PURE__*/_react.default.createElement(_page.DescriptionListStyled, {
    "data-test-subj": _test_ids.ENTITIES_HOST_OVERVIEW_RISK_LEVEL_TEST_ID,
    listItems: [hostRiskLevel],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 274,
      columnNumber: 17
    }
  }) : /*#__PURE__*/_react.default.createElement(_overview_description_list.OverviewDescriptionList, {
    dataTestSubj: _test_ids.ENTITIES_HOST_OVERVIEW_LAST_SEEN_TEST_ID,
    descriptionList: hostLastSeen,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 279,
      columnNumber: 17
    }
  })))), /*#__PURE__*/_react.default.createElement(_alert_count_insight.AlertCountInsight, {
    fieldName: 'host.name',
    name: hostName,
    openDetailsPanel: openDetailsPanel,
    "data-test-subj": _test_ids.ENTITIES_HOST_OVERVIEW_ALERT_COUNT_TEST_ID,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 288,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_misconfiguration_insight.MisconfigurationsInsight, {
    fieldName: 'host.name',
    name: hostName,
    openDetailsPanel: openDetailsPanel,
    "data-test-subj": _test_ids.ENTITIES_HOST_OVERVIEW_MISCONFIGURATIONS_TEST_ID,
    telemetryKey: _ui_metrics.MISCONFIGURATION_INSIGHT_HOST_ENTITY_OVERVIEW,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 294,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_vulnerabilities_insight.VulnerabilitiesInsight, {
    hostName: hostName,
    openDetailsPanel: openDetailsPanel,
    "data-test-subj": _test_ids.ENTITIES_HOST_OVERVIEW_VULNERABILITIES_TEST_ID,
    telemetryKey: _ui_metrics.VULNERABILITIES_INSIGHT_HOST_ENTITY_OVERVIEW,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 301,
      columnNumber: 7
    }
  }));
};
exports.HostEntityOverview = HostEntityOverview;
HostEntityOverview.displayName = 'HostEntityOverview';