"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PreviewPanelFooter = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _expandableFlyout = require("@kbn/expandable-flyout");
var _take_action_button = require("../shared/components/take_action_button");
var _utils = require("../shared/utils");
var _event_kinds = require("../shared/constants/event_kinds");
var _panel_keys = require("../shared/constants/panel_keys");
var _context = require("../shared/context");
var _test_ids = require("./test_ids");
var _kibana = require("../../../common/lib/kibana");
var _telemetry = require("../../../common/lib/telemetry");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/flyout/document_details/preview/footer.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * Footer at the bottom of preview panel with a link to open document details flyout
 */
const PreviewPanelFooter = () => {
  const {
    eventId,
    indexName,
    scopeId,
    getFieldsData,
    isRulePreview
  } = (0, _context.useDocumentDetailsContext)();
  const {
    openFlyout
  } = (0, _expandableFlyout.useExpandableFlyoutApi)();
  const {
    telemetry
  } = (0, _kibana.useKibana)().services;
  const isAlert = (0, _react.useMemo)(() => (0, _utils.getField)(getFieldsData('event.kind')) === _event_kinds.EventKind.signal, [getFieldsData]);
  const openDocumentFlyout = (0, _react.useCallback)(() => {
    openFlyout({
      right: {
        id: _panel_keys.DocumentDetailsRightPanelKey,
        params: {
          id: eventId,
          indexName,
          scopeId
        }
      }
    });
    telemetry.reportEvent(_telemetry.DocumentEventTypes.DetailsFlyoutOpened, {
      location: scopeId,
      panel: 'right'
    });
  }, [openFlyout, eventId, indexName, scopeId, telemetry]);
  const fullDetailsLink = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    onClick: openDocumentFlyout,
    target: "_blank",
    "data-test-subj": _test_ids.PREVIEW_FOOTER_LINK_TEST_ID,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, _i18n.i18n.translate('xpack.securitySolution.flyout.preview.openFlyoutLabel', {
    values: {
      isAlert
    },
    defaultMessage: 'Show full {isAlert, select, true{alert} other{event}} details'
  }))), [isAlert, openDocumentFlyout]);
  if (isRulePreview) return null;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, {
    "data-test-subj": _test_ids.PREVIEW_FOOTER_TEST_ID,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: "transparent",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd",
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 11
    }
  }, fullDetailsLink), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_take_action_button.TakeActionButton, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 13
    }
  })))));
};
exports.PreviewPanelFooter = PreviewPanelFooter;