"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getUsersColumns = void 0;
var _empty_value = require("../../../../common/components/empty_value");
var i18n = _interopRequireWildcard(require("./translations"));
var _helpers = require("../../../../common/components/tables/helpers");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getUsersColumns = (flowTarget, tableId) => [{
  field: 'node.user.name',
  name: i18n.USER_NAME,
  truncateText: false,
  mobileOptions: {
    show: true
  },
  sortable: true,
  render: userName => (0, _helpers.getRowItemsWithActions)({
    values: userName ? [userName] : undefined,
    fieldName: 'user.name',
    idPrefix: `${tableId}-table-${flowTarget}-user`
  })
}, {
  field: 'node.user.id',
  name: i18n.USER_ID,
  truncateText: false,
  mobileOptions: {
    show: true
  },
  sortable: false,
  render: userIds => (0, _helpers.getRowItemsWithActions)({
    values: userIds,
    fieldName: 'user.id',
    idPrefix: `${tableId}-table-${flowTarget}`
  })
}, {
  field: 'node.user.groupName',
  name: i18n.GROUP_NAME,
  truncateText: false,
  mobileOptions: {
    show: true
  },
  sortable: false,
  render: groupNames => (0, _helpers.getRowItemsWithActions)({
    values: groupNames,
    fieldName: 'user.group.name',
    idPrefix: `${tableId}-table-${flowTarget}`
  })
}, {
  field: 'node.user.groupId',
  name: i18n.GROUP_ID,
  truncateText: false,
  mobileOptions: {
    show: true
  },
  sortable: false,
  render: groupId => (0, _helpers.getRowItemsWithActions)({
    values: groupId,
    fieldName: 'user.group.id',
    idPrefix: `${tableId}-table-${flowTarget}`
  })
}, {
  align: 'right',
  field: 'node.user.count',
  name: i18n.DOCUMENT_COUNT,
  truncateText: false,
  mobileOptions: {
    show: true
  },
  sortable: true,
  render: docCount => (0, _empty_value.defaultToEmptyTag)(docCount)
}];
exports.getUsersColumns = getUsersColumns;