"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NetworkTopCountriesTableId = exports.NetworkTopCountriesTable = void 0;
var _fp = require("lodash/fp");
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _fastDeepEqual = _interopRequireDefault(require("fast-deep-equal"));
var _store = require("../../store");
var _search_strategy = require("../../../../../common/search_strategy");
var _use_selector = require("../../../../common/hooks/use_selector");
var _paginated_table = require("../../../components/paginated_table");
var _columns = require("./columns");
var i18n = _interopRequireWildcard(require("./translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/explore/network/components/network_top_countries_table/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const rowItems = [{
  text: i18n.ROWS_5,
  numberOfRow: 5
}, {
  text: i18n.ROWS_10,
  numberOfRow: 10
}];
const NetworkTopCountriesTableId = exports.NetworkTopCountriesTableId = 'networkTopCountries-top-talkers';
const NetworkTopCountriesTableComponent = ({
  data,
  fakeTotalCount,
  flowTargeted,
  id,
  isInspect,
  loading,
  loadPage,
  setQuerySkip,
  showMorePagesIndicator,
  totalCount,
  type
}) => {
  const dispatch = (0, _reactRedux.useDispatch)();
  const getTopCountriesSelector = (0, _react.useMemo)(() => _store.networkSelectors.topCountriesSelector(), []);
  const {
    activePage,
    limit,
    sort
  } = (0, _use_selector.useDeepEqualSelector)(state => getTopCountriesSelector(state, type, flowTargeted));
  const headerTitle = (0, _react.useMemo)(() => flowTargeted === _search_strategy.FlowTargetSourceDest.source ? i18n.SOURCE_COUNTRIES : i18n.DESTINATION_COUNTRIES, [flowTargeted]);
  const tableType = (0, _react.useMemo)(() => {
    if (type === _store.networkModel.NetworkType.page) {
      return flowTargeted === _search_strategy.FlowTargetSourceDest.source ? _store.networkModel.NetworkTableType.topCountriesSource : _store.networkModel.NetworkTableType.topCountriesDestination;
    }
    return flowTargeted === _search_strategy.FlowTargetSourceDest.source ? _store.networkModel.NetworkDetailsTableType.topCountriesSource : _store.networkModel.NetworkDetailsTableType.topCountriesDestination;
  }, [flowTargeted, type]);
  const field = sort.field === _search_strategy.NetworkTopTablesFields.bytes_out || sort.field === _search_strategy.NetworkTopTablesFields.bytes_in ? `node.network.${sort.field}` : `node.${flowTargeted}.${sort.field}`;
  const updateLimitPagination = (0, _react.useCallback)(newLimit => dispatch(_store.networkActions.updateNetworkTable({
    networkType: type,
    tableType,
    updates: {
      limit: newLimit
    }
  })), [dispatch, type, tableType]);
  const updateActivePage = (0, _react.useCallback)(newPage => dispatch(_store.networkActions.updateNetworkTable({
    networkType: type,
    tableType,
    updates: {
      activePage: newPage
    }
  })), [dispatch, type, tableType]);
  const onChange = (0, _react.useCallback)(criteria => {
    if (criteria.sort != null) {
      const splitField = criteria.sort.field.split('.');
      const lastField = (0, _fp.last)(splitField);
      const newSortDirection = lastField !== sort.field ? _search_strategy.Direction.desc : criteria.sort.direction; // sort by desc on init click
      const newTopCountriesSort = {
        field: lastField,
        direction: newSortDirection
      };
      if (!(0, _fastDeepEqual.default)(newTopCountriesSort, sort)) {
        dispatch(_store.networkActions.updateNetworkTable({
          networkType: type,
          tableType,
          updates: {
            sort: newTopCountriesSort
          }
        }));
      }
    }
  }, [sort, dispatch, type, tableType]);
  const columns = (0, _react.useMemo)(() => (0, _columns.getCountriesColumnsCurated)(flowTargeted, type, NetworkTopCountriesTableId), [flowTargeted, type]);
  return /*#__PURE__*/_react.default.createElement(_paginated_table.PaginatedTable, {
    activePage: activePage,
    columns: columns,
    dataTestSubj: `table-${tableType}`,
    headerCount: totalCount,
    headerTitle: headerTitle,
    headerUnit: i18n.UNIT(totalCount),
    id: id,
    isInspect: isInspect,
    itemsPerRow: rowItems,
    limit: limit,
    loading: loading,
    loadPage: loadPage,
    onChange: onChange,
    pageOfItems: data,
    setQuerySkip: setQuerySkip,
    showMorePagesIndicator: showMorePagesIndicator,
    sorting: {
      field,
      direction: sort.direction
    },
    totalCount: fakeTotalCount,
    updateActivePage: updateActivePage,
    updateLimitPagination: updateLimitPagination,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 157,
      columnNumber: 5
    }
  });
};
NetworkTopCountriesTableComponent.displayName = 'NetworkTopCountriesTableComponent';
const NetworkTopCountriesTable = exports.NetworkTopCountriesTable = /*#__PURE__*/_react.default.memo(NetworkTopCountriesTableComponent);