"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UncommonProcessTable = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _store = require("../../store");
var _paginated_table = require("../../../components/paginated_table");
var i18n = _interopRequireWildcard(require("./translations"));
var _use_selector = require("../../../../common/hooks/use_selector");
var _columns = require("./columns");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/explore/hosts/components/uncommon_process_table/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const tableType = _store.hostsModel.HostsTableType.uncommonProcesses;
const rowItems = [{
  text: i18n.ROWS_5,
  numberOfRow: 5
}, {
  text: i18n.ROWS_10,
  numberOfRow: 10
}];
const UncommonProcessTableComponent = /*#__PURE__*/_react.default.memo(({
  data,
  fakeTotalCount,
  id,
  isInspect,
  loading,
  loadPage,
  totalCount,
  setQuerySkip,
  showMorePagesIndicator,
  type
}) => {
  const dispatch = (0, _reactRedux.useDispatch)();
  const getUncommonProcessesSelector = (0, _react.useMemo)(() => _store.hostsSelectors.uncommonProcessesSelector(), []);
  const {
    activePage,
    limit
  } = (0, _use_selector.useDeepEqualSelector)(state => getUncommonProcessesSelector(state, type));
  const updateLimitPagination = (0, _react.useCallback)(newLimit => dispatch(_store.hostsActions.updateTableLimit({
    hostsType: type,
    limit: newLimit,
    tableType
  })), [type, dispatch]);
  const updateActivePage = (0, _react.useCallback)(newPage => dispatch(_store.hostsActions.updateTableActivePage({
    activePage: newPage,
    hostsType: type,
    tableType
  })), [type, dispatch]);
  const columns = (0, _react.useMemo)(() => (0, _columns.getUncommonColumnsCurated)(type), [type]);
  return /*#__PURE__*/_react.default.createElement(_paginated_table.PaginatedTable, {
    activePage: activePage,
    columns: columns,
    dataTestSubj: `table-${tableType}`,
    headerCount: totalCount,
    headerTitle: i18n.UNCOMMON_PROCESSES,
    headerUnit: i18n.UNIT(totalCount),
    id: id,
    isInspect: isInspect,
    itemsPerRow: rowItems,
    limit: limit,
    loading: loading,
    loadPage: loadPage,
    pageOfItems: data,
    setQuerySkip: setQuerySkip,
    showMorePagesIndicator: showMorePagesIndicator,
    totalCount: fakeTotalCount,
    updateLimitPagination: updateLimitPagination,
    updateActivePage: updateActivePage,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 7
    }
  });
});
UncommonProcessTableComponent.displayName = 'UncommonProcessTableComponent';
const UncommonProcessTable = exports.UncommonProcessTable = /*#__PURE__*/_react.default.memo(UncommonProcessTableComponent);
UncommonProcessTable.displayName = 'UncommonProcessTable';