"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useGetAlertsByRuleColumns = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _securitysolutionDataTable = require("@kbn/securitysolution-data-table");
var _formatted_number = require("../../../../common/components/formatted_number");
var _translations = require("../alerts_count_panel/translations");
var _cell_actions = require("../../../../common/components/cell_actions");
var _helpers = require("../../../../helpers");
var _translations2 = require("../../alerts_table/translations");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detections/components/alerts_kpis/alerts_by_rule_panel/columns.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const BASE_COLUMNS = [{
  field: 'rule',
  name: _translations2.ALERTS_HEADERS_RULE_NAME,
  'data-test-subj': 'alert-by-rule-table-rule-name',
  truncateText: true,
  render: rule => /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    className: "eui-textTruncate",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 32,
      columnNumber: 7
    }
  }, rule)
}, {
  field: 'value',
  name: _translations.COUNT_TABLE_TITLE,
  dataType: 'number',
  sortable: true,
  'data-test-subj': 'alert-by-rule-table-count',
  render: count => /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    grow: false,
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 44,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_formatted_number.FormattedCount, {
    count: count,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 45,
      columnNumber: 9
    }
  })),
  width: '22%'
}];
const CELL_ACTIONS_COLUMN = {
  field: 'rule',
  name: '',
  'data-test-subj': 'alert-by-rule-table-actions',
  width: '10%',
  render: rule => /*#__PURE__*/_react.default.createElement(_cell_actions.SecurityCellActions, {
    mode: _cell_actions.CellActionsMode.INLINE,
    visibleCellActions: 0,
    triggerId: _cell_actions.SecurityCellActionsTrigger.DEFAULT,
    data: {
      field: _ruleDataUtils.ALERT_RULE_NAME,
      value: rule
    },
    sourcererScopeId: (0, _helpers.getSourcererScopeId)(_securitysolutionDataTable.TableId.alertsOnAlertsPage),
    disabledActionTypes: [_cell_actions.SecurityCellActionType.SHOW_TOP_N],
    metadata: {
      scopeId: _securitysolutionDataTable.TableId.alertsOnAlertsPage
    },
    extraActionsIconType: "boxesVertical",
    extraActionsColor: "text",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 5
    }
  })
};
const ALL_COLUMNS = [...BASE_COLUMNS, CELL_ACTIONS_COLUMN];

/**
 * Returns the list of columns for the severity table for the KPI charts
 * @param showCellActions if true, add a third column for cell actions
 */
const useGetAlertsByRuleColumns = showCellActions => {
  return (0, _react.useMemo)(() => showCellActions ? ALL_COLUMNS : BASE_COLUMNS, [showCellActions]);
};
exports.useGetAlertsByRuleColumns = useGetAlertsByRuleColumns;