"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.KPIsSection = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _securitysolutionDataTable = require("@kbn/securitysolution-data-table");
var _use_data_table_filters = require("../../../../common/hooks/use_data_table_filters");
var _constants = require("../../../../common/store/inputs/constants");
var _use_selector = require("../../../../common/hooks/use_selector");
var _inputs = require("../../../../common/store/inputs");
var _actions = require("../../../../common/store/inputs/actions");
var _user_info = require("../../user_info");
var _default_config = require("../../alerts_table/default_config");
var _chart_panels = require("../../alerts_kpis/chart_panels");
var _kibana = require("../../../../common/lib/kibana");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detections/components/alerts/kpis/kpis_section.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * UI section of the alerts page that renders a series of charts.
 */
const KPIsSection = exports.KPIsSection = /*#__PURE__*/(0, _react.memo)(({
  assignees,
  runtimeMappings,
  pageFilters
}) => {
  const dispatch = (0, _reactRedux.useDispatch)();
  const {
    data
  } = (0, _kibana.useKibana)().services;
  const {
    filterManager
  } = data.query;
  const addFilter = (0, _react.useCallback)(({
    field,
    value,
    negate
  }) => {
    filterManager.addFilters([{
      meta: {
        alias: null,
        disabled: false,
        negate: negate !== null && negate !== void 0 ? negate : false
      },
      ...(value != null ? {
        query: {
          match_phrase: {
            [field]: value
          }
        }
      } : {
        exists: {
          field
        }
      })
    }]);
  }, [filterManager]);
  const getGlobalFiltersQuerySelector = (0, _react.useMemo)(() => _inputs.inputsSelectors.globalFiltersQuerySelector(), []);
  const filters = (0, _use_selector.useDeepEqualSelector)(getGlobalFiltersQuerySelector);
  const {
    showBuildingBlockAlerts,
    showOnlyThreatIndicatorAlerts
  } = (0, _use_data_table_filters.useDataTableFilters)(_securitysolutionDataTable.TableId.alertsOnAlertsPage);
  const topLevelFilters = (0, _react.useMemo)(() => {
    return [...filters, ...(0, _default_config.buildShowBuildingBlockFilter)(showBuildingBlockAlerts), ...(0, _default_config.buildThreatMatchFilter)(showOnlyThreatIndicatorAlerts), ...(0, _default_config.buildAlertAssigneesFilter)(assignees)];
  }, [assignees, showBuildingBlockAlerts, showOnlyThreatIndicatorAlerts, filters]);
  const alertsDefaultFilters = (0, _react.useMemo)(() => [...topLevelFilters, ...(pageFilters !== null && pageFilters !== void 0 ? pageFilters : [])], [topLevelFilters, pageFilters]);
  const pageFiltersIsLoading = (0, _react.useMemo)(() => !Array.isArray(pageFilters), [pageFilters]);
  const getGlobalQuerySelector = (0, _react.useMemo)(() => _inputs.inputsSelectors.globalQuerySelector(), []);
  const query = (0, _use_selector.useDeepEqualSelector)(getGlobalQuerySelector);
  const [{
    signalIndexName
  }] = (0, _user_info.useUserData)();
  const updateDateRangeCallback = (0, _react.useCallback)(({
    x
  }) => {
    if (!x) {
      return;
    }
    const [min, max] = x;
    dispatch((0, _actions.setAbsoluteRangeDatePicker)({
      id: _constants.InputsModelId.global,
      from: new Date(min).toISOString(),
      to: new Date(max).toISOString()
    }));
  }, [dispatch]);
  return /*#__PURE__*/_react.default.createElement(_chart_panels.ChartPanels, {
    addFilter: addFilter,
    alertsDefaultFilters: alertsDefaultFilters,
    isLoadingIndexPattern: pageFiltersIsLoading,
    query: query,
    runtimeMappings: runtimeMappings,
    signalIndexName: signalIndexName,
    updateDateRangeCallback: updateDateRangeCallback,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 120,
      columnNumber: 7
    }
  });
});
KPIsSection.displayName = 'KPIsSection';