"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.listFormOptions = exports.ValueListsFormComponent = exports.ValueListsForm = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _securitysolutionListHooks = require("@kbn/securitysolution-list-hooks");
var i18n = _interopRequireWildcard(require("./translations"));
var _kibana = require("../../../../common/lib/kibana");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_management_ui/components/value_lists_management_flyout/form.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const listFormOptions = exports.listFormOptions = [{
  value: 'keyword',
  text: i18n.KEYWORDS_RADIO
}, {
  value: 'ip',
  text: i18n.IP_RADIO
}, {
  value: 'ip_range',
  text: i18n.IP_RANGE_RADIO
}, {
  value: 'text',
  text: i18n.TEXT_RADIO
}];
const defaultListType = 'keyword';
const validFileTypes = ['text/csv', 'text/plain'];
const ValueListsFormComponent = ({
  onError,
  onSuccess
}) => {
  const ctrl = (0, _react.useRef)(new AbortController());
  const [file, setFile] = (0, _react.useState)(null);
  const [type, setType] = (0, _react.useState)(defaultListType);
  const filePickerRef = (0, _react.useRef)(null);
  const {
    http
  } = (0, _kibana.useKibana)().services;
  const {
    start: importList,
    ...importState
  } = (0, _securitysolutionListHooks.useImportList)();
  const fileIsValid = !file || validFileTypes.some(fileType => file.type === fileType);
  const handleRadioChange = (0, _react.useCallback)(event => setType(event.target.value), [setType]);
  const handleFileChange = (0, _react.useCallback)(files => {
    var _files$item;
    setFile((_files$item = files === null || files === void 0 ? void 0 : files.item(0)) !== null && _files$item !== void 0 ? _files$item : null);
  }, []);
  const resetForm = (0, _react.useCallback)(() => {
    var _filePickerRef$curren;
    if ((_filePickerRef$curren = filePickerRef.current) !== null && _filePickerRef$curren !== void 0 && _filePickerRef$curren.fileInput) {
      filePickerRef.current.fileInput.value = '';
      filePickerRef.current.handleChange();
    }
    setFile(null);
    setType(defaultListType);
  }, []);
  const handleCancel = (0, _react.useCallback)(() => {
    ctrl.current.abort();
  }, []);
  const handleSuccess = (0, _react.useCallback)(response => {
    resetForm();
    onSuccess(response);
  }, [resetForm, onSuccess]);
  const handleError = (0, _react.useCallback)(error => {
    onError(error);
  }, [onError]);
  const handleImport = (0, _react.useCallback)(() => {
    if (!importState.loading && file) {
      ctrl.current = new AbortController();
      importList({
        file,
        listId: undefined,
        http,
        signal: ctrl.current.signal,
        type
      });
    }
  }, [importState.loading, file, importList, http, type]);
  (0, _react.useEffect)(() => {
    if (!importState.loading && importState.result) {
      handleSuccess(importState.result);
    } else if (!importState.loading && importState.error) {
      handleError(importState.error);
    }
  }, [handleError, handleSuccess, importState.error, importState.loading, importState.result]);
  (0, _react.useEffect)(() => {
    return handleCancel;
  }, [handleCancel]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 130,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    "data-test-subj": "value-list-file-picker-row",
    label: i18n.FILE_PICKER_LABEL,
    fullWidth: true,
    isInvalid: !fileIsValid,
    error: [i18n.FILE_PICKER_INVALID_FILE_TYPE(validFileTypes.join(', '))],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 131,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFilePicker, {
    accept: validFileTypes.join(),
    "data-test-subj": "value-list-file-picker",
    id: "value-list-file-picker",
    initialPromptText: i18n.FILE_PICKER_PROMPT,
    ref: filePickerRef,
    onChange: handleFileChange,
    fullWidth: true,
    isLoading: importState.loading,
    isInvalid: !fileIsValid,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 138,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 150,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 151,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 152,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: i18n.LIST_TYPES_RADIO_LABEL,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 153,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    "data-test-subj": "value-lists-form-select-type-action",
    options: listFormOptions,
    value: type,
    onChange: handleRadioChange,
    name: "valueListType",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 154,
      columnNumber: 15
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 163,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    hasEmptyLabelSpace: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 164,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "flexEnd",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 165,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 166,
      columnNumber: 17
    }
  }, importState.loading && /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: handleCancel,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 168,
      columnNumber: 21
    }
  }, i18n.CANCEL_BUTTON)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 171,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "value-lists-form-import-action",
    onClick: handleImport,
    disabled: file == null || !fileIsValid || importState.loading,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 172,
      columnNumber: 19
    }
  }, i18n.UPLOAD_BUTTON))))))));
};
exports.ValueListsFormComponent = ValueListsFormComponent;
ValueListsFormComponent.displayName = 'ValueListsFormComponent';
const ValueListsForm = exports.ValueListsForm = /*#__PURE__*/_react.default.memo(ValueListsFormComponent);
ValueListsForm.displayName = 'ValueListsForm';