"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useUpgradePrebuiltRulesTableContext = exports.UpgradePrebuiltRulesTableContextProvider = void 0;
var _react = _interopRequireWildcard(require("react"));
var _invariant = require("../../../../../../common/utils/invariant");
var _constants = require("../constants");
var _use_prebuilt_rules_status = require("../../../../rule_management/logic/prebuilt_rules/use_prebuilt_rules_status");
var _use_prebuilt_rules_upgrade = require("../../../../rule_management/hooks/use_prebuilt_rules_upgrade");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_management_ui/components/rules_table/upgrade_prebuilt_rules_table/upgrade_prebuilt_rules_table_context.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const UpgradePrebuiltRulesTableContext = /*#__PURE__*/(0, _react.createContext)(null);
/**
 * Provides necessary data and actions for Rules Upgrade table.
 *
 * It periodically re-fetches prebuilt rules upgrade review data to detect possible cases of:
 *  - editing prebuilt rules (revision change)
 *  - releasing a new prebuilt rules package (version change)
 */
const UpgradePrebuiltRulesTableContextProvider = ({
  children
}) => {
  var _prebuiltRulesStatusR, _prebuiltRulesStatusR2;
  // Use the data from the prebuilt rules status API to determine if there are
  // rules to upgrade because it returns information about all rules without filters
  const {
    data: prebuiltRulesStatusResponse
  } = (0, _use_prebuilt_rules_status.usePrebuiltRulesStatus)();
  const hasRulesToUpgrade = ((_prebuiltRulesStatusR = prebuiltRulesStatusResponse === null || prebuiltRulesStatusResponse === void 0 ? void 0 : prebuiltRulesStatusResponse.stats.num_prebuilt_rules_to_upgrade) !== null && _prebuiltRulesStatusR !== void 0 ? _prebuiltRulesStatusR : 0) > 0;
  const tags = prebuiltRulesStatusResponse === null || prebuiltRulesStatusResponse === void 0 ? void 0 : (_prebuiltRulesStatusR2 = prebuiltRulesStatusResponse.aggregated_fields) === null || _prebuiltRulesStatusR2 === void 0 ? void 0 : _prebuiltRulesStatusR2.upgradeable_rules.tags;
  const [filterOptions, setFilterOptions] = (0, _react.useState)({});
  const [pagination, setPagination] = (0, _react.useState)({
    page: 1,
    perPage: _constants.RULES_TABLE_INITIAL_PAGE_SIZE
  });
  const [sortingOptions, setSortingOptions] = (0, _react.useState)({
    field: 'current_rule.last_updated',
    order: 'asc'
  });
  const findRulesSortField = (0, _react.useMemo)(() => ({
    'current_rule.name': 'name',
    'current_rule.risk_score': 'risk_score',
    'current_rule.severity': 'severity',
    'current_rule.last_updated': 'updated_at'
  })[sortingOptions.field], [sortingOptions.field]);
  const {
    ruleUpgradeStates,
    upgradeReviewResponse,
    isFetched,
    isLoading,
    isFetching,
    isRefetching,
    isUpgradingSecurityPackages,
    loadingRules,
    lastUpdated,
    rulePreviewFlyout,
    confirmLegacyMlJobsUpgradeModal,
    upgradeConflictsModal,
    openRulePreview,
    reFetchRules,
    upgradeRules,
    upgradeAllRules
  } = (0, _use_prebuilt_rules_upgrade.usePrebuiltRulesUpgrade)({
    pagination,
    sort: {
      field: findRulesSortField,
      order: sortingOptions.order
    },
    filter: filterOptions
  });
  const actions = (0, _react.useMemo)(() => ({
    reFetchRules,
    upgradeRules,
    upgradeAllRules,
    setFilterOptions,
    openRulePreview,
    setPagination,
    setSortingOptions
  }), [reFetchRules, upgradeRules, upgradeAllRules, openRulePreview]);
  const providerValue = (0, _react.useMemo)(() => {
    var _upgradeReviewRespons;
    return {
      state: {
        ruleUpgradeStates,
        hasRulesToUpgrade,
        filterOptions,
        tags: tags !== null && tags !== void 0 ? tags : [],
        isFetched,
        isLoading,
        isFetching,
        isRefetching,
        isUpgradingSecurityPackages,
        loadingRules,
        lastUpdated,
        pagination: {
          ...pagination,
          total: (_upgradeReviewRespons = upgradeReviewResponse === null || upgradeReviewResponse === void 0 ? void 0 : upgradeReviewResponse.total) !== null && _upgradeReviewRespons !== void 0 ? _upgradeReviewRespons : 0
        },
        sortingOptions
      },
      actions
    };
  }, [ruleUpgradeStates, hasRulesToUpgrade, filterOptions, tags, isFetched, isLoading, isFetching, isRefetching, isUpgradingSecurityPackages, loadingRules, lastUpdated, pagination, upgradeReviewResponse === null || upgradeReviewResponse === void 0 ? void 0 : upgradeReviewResponse.total, sortingOptions, actions]);
  return /*#__PURE__*/_react.default.createElement(UpgradePrebuiltRulesTableContext.Provider, {
    value: providerValue,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 241,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, confirmLegacyMlJobsUpgradeModal, upgradeConflictsModal, children, rulePreviewFlyout));
};
exports.UpgradePrebuiltRulesTableContextProvider = UpgradePrebuiltRulesTableContextProvider;
const useUpgradePrebuiltRulesTableContext = () => {
  const rulesTableContext = (0, _react.useContext)(UpgradePrebuiltRulesTableContext);
  (0, _invariant.invariant)(rulesTableContext, 'useUpgradePrebuiltRulesTableContext should be used inside UpgradePrebuiltRulesTableContextProvider');
  return rulesTableContext;
};
exports.useUpgradePrebuiltRulesTableContext = useUpgradePrebuiltRulesTableContext;