"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RuleSnoozeBadge = RuleSnoozeBadge;
var _react = _interopRequireDefault(require("react"));
var _user_info = require("../../../../detections/components/user_info");
var _privileges = require("../../../../common/utils/privileges");
var _kibana = require("../../../../common/lib/kibana");
var _use_fetch_rules_snooze_settings_query = require("../../api/hooks/use_fetch_rules_snooze_settings_query");
var _use_rule_snooze_settings = require("./use_rule_snooze_settings");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_management/components/rule_snooze_badge/rule_snooze_badge.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function RuleSnoozeBadge({
  ruleId,
  showTooltipInline = false
}) {
  const RulesListNotifyBadge = (0, _kibana.useKibana)().services.triggersActionsUi.getRulesListNotifyBadge;
  const {
    snoozeSettings,
    error
  } = (0, _use_rule_snooze_settings.useRuleSnoozeSettings)(ruleId);
  const [{
    canUserCRUD
  }] = (0, _user_info.useUserData)();
  const hasCRUDPermissions = (0, _privileges.hasUserCRUDPermission)(canUserCRUD);
  const invalidateFetchRuleSnoozeSettings = (0, _use_fetch_rules_snooze_settings_query.useInvalidateFetchRulesSnoozeSettingsQuery)();
  return /*#__PURE__*/_react.default.createElement(RulesListNotifyBadge, {
    ruleId: ruleId,
    snoozeSettings: snoozeSettings,
    loading: !snoozeSettings && !error,
    disabled: !hasCRUDPermissions || error,
    showTooltipInline: showTooltipInline,
    onRuleChanged: invalidateFetchRuleSnoozeSettings,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 35,
      columnNumber: 5
    }
  });
}