"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ScheduleItemField = ScheduleItemField;
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _shared_imports = require("../../../../shared_imports");
var I18n = _interopRequireWildcard(require("./translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_creation/components/schedule_item_field/schedule_item_field.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const timeTypeOptions = [{
  value: 's',
  text: I18n.SECONDS
}, {
  value: 'm',
  text: I18n.MINUTES
}, {
  value: 'h',
  text: I18n.HOURS
}, {
  value: 'd',
  text: I18n.DAYS
}];
function ScheduleItemField({
  field,
  isDisabled,
  dataTestSubj,
  idAria,
  minValue = Number.MIN_SAFE_INTEGER,
  maxValue = Number.MAX_SAFE_INTEGER,
  units = DEFAULT_TIME_DURATION_UNITS,
  fullWidth = false
}) {
  const [timeType, setTimeType] = (0, _react.useState)(units[0]);
  const [timeVal, setTimeVal] = (0, _react.useState)(0);
  const {
    isInvalid,
    errorMessage
  } = (0, _shared_imports.getFieldValidityAndErrorMessage)(field);
  const {
    value,
    setValue
  } = field;
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const formRowStyles = (0, _react2.css)`
    max-width: none;

    .euiFormControlLayout__append {
      padding-inline: 0 !important;
    }

    .euiFormControlLayoutIcons {
      color: ${euiTheme.colors.primary};
    }
  `;
  const timeUnitSelectStyles = (0, _react2.css)`
    min-width: 106px; // Preserve layout when disabled & dropdown arrow is not rendered
    box-shadow: none;
    background: ${euiTheme.colors.backgroundBasePrimary} !important;
    color: ${euiTheme.colors.primary};
  `;
  const onChangeTimeType = (0, _react.useCallback)(e => {
    setTimeType(e.target.value);
    setValue(`${timeVal}${e.target.value}`);
  }, [setValue, timeVal]);
  const onChangeTimeVal = (0, _react.useCallback)(e => {
    const number = e.target.value === '' ? minValue : parseInt(e.target.value, 10);
    if (Number.isNaN(number)) {
      return;
    }
    const newTimeValue = saturate(number, minValue, maxValue);
    setTimeVal(newTimeValue);
    setValue(`${newTimeValue}${timeType}`);
  }, [minValue, maxValue, setValue, timeType]);
  (0, _react.useEffect)(() => {
    if (value === `${timeVal}${timeType}`) {
      return;
    }
    const isNegative = value.startsWith('-');
    const durationRegexp = new RegExp(`^\\-?(\\d+)(${units.join('|')})$`);
    const durationMatchArray = value.match(durationRegexp);
    if (!durationMatchArray) {
      return;
    }
    const [, timeStr, unit] = durationMatchArray;
    const time = parseInt(timeStr, 10) * (isNegative ? -1 : 1);
    setTimeVal(time);
    setTimeType(unit);
  }, [timeType, units, timeVal, value]);
  const label = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    justifyContent: "spaceBetween",
    alignItems: "center",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 123,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    component: "span",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 124,
      columnNumber: 9
    }
  }, field.label), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    component: "span",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 127,
      columnNumber: 9
    }
  }, field.labelAppend)), [field.label, field.labelAppend]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    css: formRowStyles,
    label: label,
    helpText: field.helpText,
    error: errorMessage,
    isInvalid: isInvalid,
    fullWidth: fullWidth,
    "data-test-subj": dataTestSubj,
    describedByIds: idAria ? [idAria] : undefined,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 136,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
    isInvalid: isInvalid,
    append: /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
      css: timeUnitSelectStyles,
      fullWidth: true,
      options: timeTypeOptions.filter(type => units.includes(type.value)),
      value: timeType,
      onChange: onChangeTimeType,
      disabled: isDisabled,
      "aria-label": field.label,
      "data-test-subj": "timeType",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 149,
        columnNumber: 11
      }
    }),
    fullWidth: true,
    min: minValue,
    max: maxValue,
    value: timeVal,
    onChange: onChangeTimeVal,
    disabled: isDisabled,
    "data-test-subj": "interval",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 146,
      columnNumber: 7
    }
  }));
}
const DEFAULT_TIME_DURATION_UNITS = ['s', 'm', 'h', 'd'];
function saturate(input, minValue, maxValue) {
  return Math.max(minValue, Math.min(input, maxValue));
}