"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MlJobStatusBadge = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _helpers = require("../../../../../common/machine_learning/helpers");
var i18n = _interopRequireWildcard(require("./translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_creation/components/ml_job_status_badge/ml_job_status_badge.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const MlJobStatusBadgeComponent = ({
  job
}) => {
  const isStarted = (0, _helpers.isJobStarted)(job.jobState, job.datafeedState);
  const color = isStarted ? 'success' : 'danger';
  const text = isStarted ? i18n.ML_JOB_STARTED : i18n.ML_JOB_STOPPED;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    "data-test-subj": "machineLearningJobStatus",
    color: color,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 27,
      columnNumber: 5
    }
  }, text);
};
const MlJobStatusBadge = exports.MlJobStatusBadge = /*#__PURE__*/(0, _react.memo)(MlJobStatusBadgeComponent);