"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PromotionRulesTable = exports.PromotionRuleTabs = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _loader = require("../../../common/components/loader");
var _privileges = require("../../../common/utils/privileges");
var _use_rule_management_filters = require("../../../detection_engine/rule_management/logic/use_rule_management_filters");
var _use_upgrade_security_packages = require("../../../detection_engine/rule_management/logic/use_upgrade_security_packages");
var _constants = require("../../../detection_engine/rule_management_ui/components/rules_table/constants");
var _rules_table_context = require("../../../detection_engine/rule_management_ui/components/rules_table/rules_table/rules_table_context");
var _use_columns = require("../../../detection_engine/rule_management_ui/components/rules_table/use_columns");
var _user_info = require("../../../detections/components/user_info");
var i18n = _interopRequireWildcard(require("./translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/configurations/tabs/promotion_rules/promotion_rules_table.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const INITIAL_SORT_FIELD = 'name';
const NO_ITEMS_MESSAGE = /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
  title: /*#__PURE__*/_react.default.createElement("h3", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 43,
      columnNumber: 26
    }
  }, i18n.NO_RULES),
  titleSize: "xs",
  body: i18n.NO_RULES_BODY,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 43,
    columnNumber: 3
  }
});
let PromotionRuleTabs = exports.PromotionRuleTabs = /*#__PURE__*/function (PromotionRuleTabs) {
  PromotionRuleTabs["management"] = "management";
  PromotionRuleTabs["monitoring"] = "monitoring";
  return PromotionRuleTabs;
}({});
const PromotionRulesTable = () => {
  var _ruleManagementFilter, _ruleManagementFilter2;
  const isUpgradingSecurityPackages = (0, _use_upgrade_security_packages.useIsUpgradingSecurityPackages)();
  const rulesTableContext = (0, _rules_table_context.useRulesTableContext)();
  const {
    data: ruleManagementFilters
  } = (0, _use_rule_management_filters.useRuleManagementFilters)();
  const [currentTab, setCurrentTab] = (0, _react.useState)(PromotionRuleTabs.management);
  const {
    state: {
      rules,
      isFetched,
      isRefetching,
      pagination,
      sortingOptions
    },
    actions: {
      setPage,
      setPerPage,
      setSortingOptions
    }
  } = rulesTableContext;
  const paginationMemo = (0, _react.useMemo)(() => {
    return {
      pageIndex: pagination.page - 1,
      pageSize: pagination.perPage,
      totalItemCount: pagination.total,
      pageSizeOptions: _constants.RULES_TABLE_PAGE_SIZE_OPTIONS
    };
  }, [pagination.page, pagination.perPage, pagination.total]);
  const tableOnChangeCallback = (0, _react.useCallback)(({
    page,
    sort
  }) => {
    var _ref, _sort$direction;
    setSortingOptions({
      field: (_ref = sort === null || sort === void 0 ? void 0 : sort.field) !== null && _ref !== void 0 ? _ref : INITIAL_SORT_FIELD,
      order: (_sort$direction = sort === null || sort === void 0 ? void 0 : sort.direction) !== null && _sort$direction !== void 0 ? _sort$direction : 'desc'
    });
    setPage(page.index + 1);
    setPerPage(page.size);
  }, [setPage, setPerPage, setSortingOptions]);
  const rulesColumns = useRulesColumns({
    currentTab
  });
  const handleTabClick = (0, _react.useCallback)(tabId => {
    setCurrentTab(tabId);
    rulesTableContext.actions.setPage(1);
    rulesTableContext.actions.setPerPage(pagination.perPage);
    rulesTableContext.actions.setSortingOptions({
      field: INITIAL_SORT_FIELD,
      order: 'desc'
    });
  }, [pagination.perPage, rulesTableContext.actions]);
  const installedTotal = ((_ruleManagementFilter = ruleManagementFilters === null || ruleManagementFilters === void 0 ? void 0 : ruleManagementFilters.rules_summary.custom_count) !== null && _ruleManagementFilter !== void 0 ? _ruleManagementFilter : 0) + ((_ruleManagementFilter2 = ruleManagementFilters === null || ruleManagementFilters === void 0 ? void 0 : ruleManagementFilters.rules_summary.prebuilt_installed_count) !== null && _ruleManagementFilter2 !== void 0 ? _ruleManagementFilter2 : 0);
  const ruleTabs = (0, _react.useMemo)(() => [{
    id: PromotionRuleTabs.management,
    name: i18n.INSTALLED_RULES_TAB,
    append: installedTotal > 0 ? /*#__PURE__*/_react.default.createElement(_eui.EuiNotificationBadge, {
      size: "m",
      color: "subdued",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 109,
        columnNumber: 13
      }
    }, installedTotal) : undefined,
    isSelected: currentTab === PromotionRuleTabs.management,
    onClick: () => handleTabClick(PromotionRuleTabs.management)
  }, {
    id: PromotionRuleTabs.monitoring,
    name: i18n.RULE_MONITORING_TAB,
    append: installedTotal > 0 ? /*#__PURE__*/_react.default.createElement(_eui.EuiNotificationBadge, {
      size: "m",
      color: "subdued",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 121,
        columnNumber: 13
      }
    }, installedTotal) : undefined,
    isSelected: currentTab === PromotionRuleTabs.monitoring,
    onClick: () => handleTabClick(PromotionRuleTabs.monitoring)
  }], [currentTab, handleTabClick, installedTotal]);
  const shouldShowLinearProgress = isFetched && isRefetching || isUpgradingSecurityPackages;
  const shouldShowLoadingOverlay = !isFetched && isRefetching;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTabs, {
    size: "m",
    bottomBorder: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 137,
      columnNumber: 7
    }
  }, ruleTabs.map(tab => /*#__PURE__*/_react.default.createElement(_eui.EuiTab, (0, _extends2.default)({
    key: tab.id
  }, tab, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 139,
      columnNumber: 11
    }
  }), tab.name))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 144,
      columnNumber: 7
    }
  }), shouldShowLinearProgress && /*#__PURE__*/_react.default.createElement(_eui.EuiProgress, {
    "data-test-subj": "loadingRulesInfoProgress",
    size: "xs",
    position: "absolute",
    color: "accent",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 146,
      columnNumber: 9
    }
  }), shouldShowLoadingOverlay && /*#__PURE__*/_react.default.createElement(_loader.Loader, {
    "data-test-subj": "loadingPanelAllRulesTable",
    overlay: true,
    size: "xl",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 154,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    itemId: "id",
    items: rules,
    noItemsMessage: NO_ITEMS_MESSAGE,
    onChange: tableOnChangeCallback,
    pagination: paginationMemo,
    sorting: {
      sort: {
        // EuiBasicTable has incorrect `sort.field` types which accept only `keyof Item` and reject fields in dot notation
        field: sortingOptions.field,
        direction: sortingOptions.order
      }
    },
    columns: rulesColumns,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 156,
      columnNumber: 7
    }
  }));
};
exports.PromotionRulesTable = PromotionRulesTable;
const useRulesColumns = ({
  currentTab
}) => {
  const [{
    canUserCRUD
  }] = (0, _user_info.useUserData)();
  const hasPermissions = (0, _privileges.hasUserCRUDPermission)(canUserCRUD);
  const enabledColumn = (0, _use_columns.useEnabledColumn)({
    hasCRUDPermissions: hasPermissions,
    isLoadingJobs: false,
    mlJobs: [],
    startMlJobs: async jobIds => {}
  });
  const executionStatusColumn = (0, _use_columns.useRuleExecutionStatusColumn)({
    sortable: true,
    width: '16%',
    isLoadingJobs: false,
    mlJobs: []
  });
  return (0, _react.useMemo)(() => {
    if (currentTab === PromotionRuleTabs.monitoring) {
      return [{
        ..._use_columns.RULE_NAME_COLUMN,
        render: value => /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
          size: "s",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 201,
            columnNumber: 44
          }
        }, value),
        width: '38%'
      }, _use_columns.INDEXING_DURATION_COLUMN, _use_columns.SEARCH_DURATION_COLUMN, _use_columns.LAST_EXECUTION_COLUMN, executionStatusColumn, enabledColumn];
    }
    return [{
      ..._use_columns.RULE_NAME_COLUMN,
      render: value => /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 215,
          columnNumber: 42
        }
      }, value),
      width: '100%'
    }, _use_columns.LAST_EXECUTION_COLUMN, executionStatusColumn, enabledColumn];
  }, [currentTab, enabledColumn, executionStatusColumn]);
};