"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useIsOpenState = void 0;
var _react = require("react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useIsOpenState = (defaultValue, {
  onOpen,
  onClose,
  onToggle
} = {}) => {
  const [isOpen, setIsOpen] = (0, _react.useState)(defaultValue);
  const open = (0, _react.useCallback)(() => {
    setIsOpen(true);
    onOpen === null || onOpen === void 0 ? void 0 : onOpen();
  }, [onOpen]);
  const close = (0, _react.useCallback)(() => {
    setIsOpen(false);
    onClose === null || onClose === void 0 ? void 0 : onClose();
  }, [onClose]);
  const toggle = (0, _react.useCallback)(() => {
    setIsOpen(prev => !prev);
    onToggle === null || onToggle === void 0 ? void 0 : onToggle();
  }, [onToggle]);
  return {
    isOpen,
    open,
    close,
    toggle
  };
};
exports.useIsOpenState = useIsOpenState;