"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SAVE_WITH_ERRORS_MODAL_TITLE = exports.SAVE_WITH_ERRORS_MESSAGE = exports.CONFIRM = exports.CANCEL = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SAVE_WITH_ERRORS_MODAL_TITLE = exports.SAVE_WITH_ERRORS_MODAL_TITLE = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.upgradeRules.saveWithErrorsConfirmationModal.title', {
  defaultMessage: 'There are validation errors'
});
const CANCEL = exports.CANCEL = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.upgradeRules.saveWithErrorsConfirmationModal.cancel', {
  defaultMessage: 'Cancel'
});
const CONFIRM = exports.CONFIRM = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.upgradeRules.saveWithErrorsConfirmationModal.confirm', {
  defaultMessage: 'Confirm'
});
const SAVE_WITH_ERRORS_MESSAGE = errorsCount => _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.saveWithErrorsModalMessage', {
  defaultMessage: 'There {errorsCount, plural, one {is} other {are}} {errorsCount} validation {errorsCount, plural, one {error} other {errors}} which can lead to failed rule executions, save anyway?',
  values: {
    errorsCount
  }
});
exports.SAVE_WITH_ERRORS_MESSAGE = SAVE_WITH_ERRORS_MESSAGE;