"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.plugin = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _timeline = require("../../../../../../common/api/timeline");
var _selectable_timeline = require("../../../../../timelines/components/timeline/selectable_timeline");
var _link_to = require("../../../link_to");
var _constants = require("./constants");
var i18n = _interopRequireWildcard(require("./translations"));
var _types = require("../../../../../app/types");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/common/components/markdown_editor/plugins/timeline/plugin.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const TimelineEditorComponent = ({
  onClosePopover,
  onInsert
}) => {
  const {
    formatUrl
  } = (0, _link_to.useFormatUrl)(_types.SecurityPageName.timelines);
  const handleGetSelectableOptions = (0, _react.useCallback)(({
    timelines
  }) => [...timelines.map((t, index) => ({
    description: t.description,
    favorite: t.favorite,
    label: t.title,
    id: t.savedObjectId,
    key: `${t.title}-${index}`,
    title: t.title,
    checked: undefined
  }))], []);
  const handleTimelineChange = (0, _react.useCallback)((timelineTitle, timelineId) => {
    const url = formatUrl((0, _link_to.getTimelineUrl)(timelineId !== null && timelineId !== void 0 ? timelineId : ''), {
      absolute: true,
      skipSearch: true
    });
    onInsert(`[${timelineTitle}](${url})`, {
      block: false
    });
  }, [formatUrl, onInsert]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_selectable_timeline.SelectableTimeline, {
    hideUntitled: true,
    getSelectableOptions: handleGetSelectableOptions,
    onTimelineChange: handleTimelineChange,
    onClosePopover: onClosePopover,
    timelineType: _timeline.TimelineTypeEnum.default,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 9
    }
  })));
};
const TimelineEditor = /*#__PURE__*/(0, _react.memo)(TimelineEditorComponent);
const plugin = ({
  interactionsUpsellingMessage,
  canSeeTimeline
}) => {
  return {
    name: _constants.ID,
    button: {
      label: interactionsUpsellingMessage !== null && interactionsUpsellingMessage !== void 0 ? interactionsUpsellingMessage : i18n.INSERT_TIMELINE,
      iconType: 'timeline',
      isDisabled: !canSeeTimeline || !!interactionsUpsellingMessage
    },
    helpText: /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
      language: "md",
      paddingSize: "s",
      fontSize: "l",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 93,
        columnNumber: 7
      }
    }, '[title](url)'),
    editor: function editor({
      node,
      onSave,
      onCancel
    }) {
      return /*#__PURE__*/_react.default.createElement(TimelineEditor, {
        onClosePopover: onCancel,
        onInsert: onSave,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 98,
          columnNumber: 14
        }
      });
    }
  };
};
exports.plugin = plugin;